#include <stdio.h>
#include "body.h"

extern int debug;
FILE *fopen();

pfile(fname,start,number,lwcflag)
char * fname;
int start;
int number;
int lwcflag;
{
    FILE *fd;
    IFDEBUG(D_PFILE)
        (void) fprintf(stderr,
	"pfile: fname = %s, start = %d, number = %d, lwcflag = %d\n",
	fname == DE_FILE ? "stdin" : fname, start, number, lwcflag);
    /*
     * open the file or set the descriptor to standard input
     */
    if (fname == DE_FILE) {
	fd = stdin;
    } else {
	if ((fd = fopen(fname,"r")) == NULL)
	   return(-1);
    }
    switch (lwcflag) {
	case L_FLAG:
	    if (lskip(start,fd) == 1)
	        (void) lprint(number,fd);
	    break;
	case W_FLAG:
	    if (wskip(start,fd) == 1)
	        (void) wprint(number,fd);
	    break;
        case C_FLAG:
	    if (cskip(start,fd) == 1)
	        (void) cprint(number,fd);
	    break;
	default:
	    if (lskip(start,fd) == 1)
	    	(void) lprint(number,fd);
	    break;
    }
    if (fname != DE_FILE) (void) fclose(fd);
    return(0);
}
