#include <stdio.h>
#include <ctype.h>
#include <curses.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

/***************************************************************************/
/*                                                                         */
/*                                 Uzap!                                   */
/*                                                                         */
/*                 Copyright (c) 1989  Robert Silvers                      */
/*                        -All rights reserved-                            */
/*                                                                         */
/*                 Developed at the University of Lowell                   */
/*                                                                         */
/* This software is supplied free of charge.  This software, or any part   */
/* of it, may  not  be  redistributed or otherwise made available to, or   */
/* used  by, any  other  person  without the inclusion of this copyright   */
/* notice.  This software may not be used to make a profit in any way.     */
/*                                                                         */
/* This  software  is provided with absolutely no warranty, to the extent  */
/* permitted  by  applicable  state law.  In no event, unless required by  */
/* applicable law, will the author(s) of this this software be liable for  */
/* any damages caused by this software.                                    */
/*                                                                         */
/*          Send bugs and comments to: rsilvers@hawk.ulowell.edu           */
/***************************************************************************/
/* 01/01/89 Uzap concieved and started.                                    */
/* 01/05/89 7:41am, loaded itself, modified it's name, and saved it.       */
/* 01/06/89 7:21am, both edits work, all done but undo.  80 Hours work.    */
/***************************************************************************/

#define PRINTB(X) Bold(); printf(X); Normal()
#define PRINTM(x) CHome(); printf(x); Home()
#define PRINTG(x) Graphics(); printf(x); Asc()

int pos;                   /* Position in binary             */
int block;                 /* Current block displayed        */
int loaded;                /* TRUE if a file is loaded       */
int modified;              /* TRUE if file was modified      */
int max;                   /* Number of blocks in file       */
int size;                  /* Size of file                   */
unsigned char string[512]; /* Global search string           */
char filename[128];        /* Filename used for I            */
char sfilename[128];       /* Actual saved-filename          */
char dfilename[128];       /* Default save-filename          */
unsigned char *image;      /* The binary image to edit       */

typedef struct node ELEMENT;
typedef ELEMENT    *LINK;

LINK head;                 /* First node                     */
LINK tail;                 /* Last node                      */
struct node{               /* Undo buffer                    */
   int address;
   unsigned char value;
   struct node *next;
   struct node *prev;
} undobuffer;

char GetKey();
void Cls(), Bold(), Blink(), Inverse(), Underline(), Normal(), Graphics(),
     Asc(), DrawScreen(), Refresh(), Move(), GetEscSequence(), Home(),
     Beep(), abort(), cont(), CHome(), IsPrint(), Table();


main(argc, argv)
int argc;
char *argv[];{

char c, opt[2];
int direction= 0, index, x, DeHexString(), dehexres, laststrlen;
void Begin(), End(), Up(), Down(), Search(), HexE(), AscE(), Quit(), Undo(), 
     Goto(), Jump(), Load(), Save();

   umask(022);
   signal(SIGINT, abort); /* Trap interupts */
   signal(SIGHUP, abort);
   signal(SIGTSTP, abort);
   signal(SIGSTOP, abort);
   signal(SIGCONT, cont);

   if(argc > 2){
      fprintf(stderr, "usage: %s [filename]\n", argv[0]);
      exit(0);
   }

   fprintf(stderr, "%d[61\"p", 27);  /* Put term in vt100 mode */ 
   Asc();
   Normal();

   initscr();
   loaded= modified= FALSE;

   Cls();
   DrawScreen();

   if(argc==2){
      Load(argv[1]);
   }else{
      PRINTM("Waiting for command");
   }
   raw();
   noecho();

   while(1){
      GetEscSequence(opt);
      if(islower(opt[0])) opt[0]= toupper(opt[0]);

      switch(opt[0]){
         case 'L':
	    echo();
	    noraw();
            PRINTM("Enter complete path to file");
            Move(17, 14);
            printf("                                                         ");
            Move(17, 14);
            scanf("%s", filename);
            c= getchar();
	    noecho();
	    raw();
	    Load(filename);
	    break;
	 case 'S':
	    CHome();
	    echo();
	    noraw();
            printf("Enter save-file, return for %s", dfilename);
            Move(17, 14);
            printf("                                                         ");
            Move(17, 14);
	    x= 0;
	    while((sfilename[x++]= getchar())!='\n');
	    noecho();
	    raw();
	    if(sfilename[0]=='\n') 
	      Save(dfilename);
            else{
	      sfilename[x - 1]='\0';
	      Save(sfilename);
            }
            break;
	 case 'Q':
	    Quit();
            break;
         case 'H':
	    HexE();
	    break;
         case 'A':
	    AscE();
	    break;
         case 'U':
	    Undo();
	    break;
         case 'T':
	    Table();
	    break;
         case 'G':
	    Goto();
	    break;
         case 'J':
	    Jump();
	    break;
         case '>':
            if(loaded){
	       direction= 1;
	       echo();
	       noraw();
               PRINTM("Enter string to locate ($num for hex):");
               Move(19, 53);
	       index= 1;
               string[0]= '0';
	       while((string[index++]=getchar())!='\n'); /* Allows spaces */
	       string[index - 1]= 0;

	       noecho();
	       raw();
	       dehexres= DeHexString(string);
               if(dehexres==-1){
		  PRINTM("Not a valid HEX number");
	       }else if(dehexres==1){
	          laststrlen= (index - 2) / 2;
	          Search(direction, laststrlen);
               }else{
	          laststrlen= index - 2;
	          Search(direction, laststrlen);
               }
            }else{
	       PRINTM("Must load a file first");
            }
	    break;
         case '<':
            if(loaded){
	       direction= -1;
	       echo();
	       noraw();
               PRINTM("Enter string to locate ($num for hex):");
               Move(19, 53);

	       index= 1;
               string[0]= '0';
	       while((string[index++]=getchar())!='\n');
	       noecho();
	       raw();
	       string[index - 1]= 0;

	       dehexres= DeHexString(string);
               if(dehexres==-1){
		  PRINTM("Not a valid HEX number");
	       }else if(dehexres==1){
	          laststrlen= (index - 2) / 2;
	          Search(direction, laststrlen);
               }else{
	          laststrlen= index - 2;
	          Search(direction, laststrlen);
	       }
            }else{
	       PRINTM("Must load a file first");
            }
	    break;
         case 'C':
	    if(direction==0){
	       PRINTM("No search to continue");
	    }else{
	       Search(direction, laststrlen);
            }
	    break;
         case 12:
	    Refresh();
	    PRINTM("Waiting for command");
	    break;
         case  3:     /* Control-C */
            PRINTM("Hit 'Q' to exit");
	    break;
         case 27:
	    if(opt[2]=='D') Begin();
	    if(opt[2]=='C') End();
	    if(opt[2]=='A') Up();
	    if(opt[2]=='B') Down();
	    break;
         default:
            PRINTM("Not a valid command");
	    break;
      } /* case */
   } /* while */
} /* main */


void Load(loadfile)
char *loadfile;{

register  x;
char c;
FILE *file, *fopen();
struct stat buf;

   if((file= fopen(loadfile, "r"))==NULL){
      CHome();
      Beep();
      printf("Cannot open file %s", loadfile);
      Move(17, 14);
      printf("%s               ", dfilename);
      Home();
      return;
   }
   Blink();
   PRINTM("LOADING");
   Normal();
   fflush(stdout);
   stat(loadfile, &buf); 
   size= buf.st_size;
   max= size / 240;
   free(image);
   image= (unsigned char*)calloc(size, sizeof(unsigned char)); 
   pos= block= 0; 
   for(x= 0; x < size; x++) image[x]= getc(file);
   CHome();
   printf("Image loaded, filesize= %d bytes           ", size);
   Move(17, 14);
   printf("%s               ", loadfile);
   Home();
   strcpy(dfilename, loadfile);
   fclose(file);
   modified= FALSE;
   loaded= TRUE;
   ShowData();
} /* Load */

void Save(savefile)
char *savefile;{
FILE *file, *fopen();
register x;

   if((file= fopen(savefile, "w"))==NULL){
      CHome();
      Beep();
      printf("Cannot open file %s for writing", savefile);
      Home();
      return;
   }
   Blink();
   PRINTM("SAVING");
   Normal();
   fflush(stdout);
   for(x= 0; x < size; x++) fputc(image[x], file);
   PRINTM("File saved");
   strcpy(dfilename, savefile);
   fclose(file);
   modified= FALSE;
} /* Save */


void Quit(){
char answer;

   if(modified){
      PRINTM("File modified, Ok to exit?");
      Move(19, 41);
      answer= GetKey();
      if(answer=='y'){
         CHome();
         PRINTB("Exiting...");
         Cls();
         free(image);
         endwin();

	 echo();
	 noraw();

         exit(0);
      }
      PRINTM("Returning to command mode");
      return;
   }
   CHome();
   PRINTB("Exiting...");
   Cls();
   free(image);
   endwin();
   exit(0);
}


void GetEscSequence(key)
char key[2];{

   key[0]= key[1]= key[2]= 0; 

   key[0]= getchar();
   if(key[0]==27){
      key[1]= getchar();
      if(key[1]=='[')
	 key[2]= getchar();
      else
	 ungetc(key[1], stdin);
   }
   Normal();
} /* GetEscSequence */


char GetKey(){ /* Gets a char without waiting for return */
char c;

   c= getchar();
   Normal(); /* Kill any ESC chars. */
   return(c);
} /* GetKey */


