#include "globals.h" 

/***************************************************************************/
/*                                                                         */
/*                               Uzap!                                     */
/*                                                                         */
/*        Copyright (c) 1989  Robert Silvers - pRevious, Inc.              */
/*                       -All rights reserved-                             */
/*                                                                         */
/*                 Developed at the University of Lowell                   */
/*                                                                         */
/* This software is supplied free of charge.  This software, or any part   */
/* of it, may  not  be  redistributed or otherwise made available to, or   */
/* used  by, any  other  person  without the inclusion of this copyright   */
/* notice.  This software may not be used to make a profit in any way.     */
/*                                                                         */
/* This  software  is provided with absolutely no warranty, to the extent  */
/* permitted  by  applicable  state law.  In no event, unless required by  */
/* applicable law, will the author(s) of this this software be liable for  */
/* any damages caused by this software.                                    */
/*                                                                         */
/*                                                                         */
/*          Send comments and bugs to: rsilvers@hawk.ulowell.edu           */
/***************************************************************************/
/* 01/05/89 7:41am, loaded itself, modified it's name, and saved it.       */
/***************************************************************************/


void Begin(){
   pos= 0;
   block= 0;
   PRINTM("At begining of data");
   ShowData();
}

void End(){
   pos= 240 * max;
   block= max;
   PRINTM("At end of data");
   ShowData();
}

void Up(){
   if (block > 0){
      pos= pos - 240;
      block--;
      PRINTM("Moving backward one block");
      ShowData();
   }else{
      PRINTM("Already at begining of data");
   }
}

void Down(){
   if (block < max){
      block++;
      pos= pos + 240;
      PRINTM("Moving forward one block");
      ShowData();
   }else{
      PRINTM("Already at end of data");
   }
}


void Goto(){
int sector;

   if(loaded){
      echo();
      noraw();
      PRINTM("Enter sector to goto:");
      Move(19, 36);
      scanf("%d", &sector);
      Move(19, 14);
      fflush(stdout);
      sector--;
      if(sector >= 0 && sector <= max){
         block= sector;
         pos= 240 * block;
         ShowData();
	 PRINTM("At requested sector");
      }else{
         PRINTM("Sector out of range");
      }
      sector= getchar(); /* Skip EOL */
   }else{ 
      PRINTM("Must load a file first");
   } /* if */
   noecho();
   raw();
} /* Goto */


void Jump(){
int byte;

   if(loaded){
      echo();
      noraw();
      PRINTM("Enter byte to jump to:");
      Move(19, 37);
      scanf("%d", &byte);
      Move(19, 14);
      fflush(stdout);
      if(byte >= 0 && byte <= size){
         block= byte / 240;
         pos= byte;
         ShowData();
	 PRINTM("At sector of requested byte");
      }else{
         PRINTM("Byte out of range");
      }
      byte= getchar(); /* Skip EOL */
   }else{ 
      PRINTM("Must load a file first");
   } /* if */
   noecho();
   raw();
} /* Goto */


void Search(dir, length)
int dir, length;{
int x, y, count, cintowin, index;
register i;
unsigned char hnum[16];

   Blink();
   if(dir==1){
      PRINTM("Searching forward");
   }else{
      PRINTM("Searching backward");
   }
   Normal();
   fflush(stdout);

   i= pos;
   while(1){
      i+= dir;
      if(i>=(size + 1) || i<=-1) break;
      if(!strncmp(image + i, string, length)){
         PRINTM("String found");
	 block= (i / 240);
	 pos= i;
	 ShowData();
	 cintowin= pos - (block * 240);

         /* Highlight HEX version of string */

	 y= cintowin / 20;  /* Compute position of string on screen */
	 x= (cintowin - (y * 20)) + 1; 
	 count= x - 1;         /* Set count */
	 x= x + (x - 1);       /* Two chars per digit */
	 x+= x / 8;            /* Allow for spaces */

	 Bold();            
	 Move(y + 3, x + 3);
	 index= 0;
	 while(index < length && y < 12){          /* Allow for wrap */
	    sprintf(hnum, "%2x", string[index++]); /* Get HEX value  */
	    if(hnum[0]==' ') hnum[0]='0';
	    if(islower(hnum[0])) hnum[0]=toupper(hnum[0]); /* Uppercase */
	    if(islower(hnum[1])) hnum[1]=toupper(hnum[1]);
	    putchar(hnum[0]);
	    putchar(hnum[1]);
	    count++;
            if(!(count%4)) putchar(' ');
            if(!(count%20)) Move(++y + 3, 4); /* Wrap */ 
         }

         /* Highlight ascii version of string */

	 y= cintowin / 20;  
	 x= cintowin - (y * 20); 
	 count= x;
	 Move(y + 3, x + 55);
	 index= 0;
	 while(index < length && y < 12){ /* Allow for wrap */
	    if(IsPrint(string[index]))
	       putchar(string[index]);
            else
	       putchar(0);
	    index++;
	    count++;
            if(!(count%20)) Move(++y + 3, 55); /* Wrap */ 
         }
	 Normal();
	 Home();
	 return;
      }
   } /* while */
   Beep();
   PRINTM("String not found");
} /* Search */


/* Converts hex search string to ascii chars if it starts with a '$', */
/* else, it leaves it alone.                                          */

int DeHexString(hex)
unsigned char *hex;{

int x, i, len, ishex=FALSE;
unsigned char hdigit[16], temp[128];

   len= strlen(hex) - 1;

   if(hex[1]=='$'){
      ishex=TRUE;
      strcpy(hex, hex + 1);
      hex[0]= '0';
      for(x= 0; x < len; x++){ /* Convert to lower */
         if(isupper(hex[x])) hex[x]= tolower(hex[x]);
	 if(!(isxdigit(hex[x]))){
	    return(-1);
         }
      }
      for(x= 0; x < len - 1; x+= 2){
         strcpy(hdigit, hex + (len - x - 2), 2);
         hdigit[2]= '\0';
   
         if(hdigit[0] < 96) hdigit[0]= hdigit[0] - 48;
         else hdigit[0]= hdigit[0] - 87;
         if(hdigit[1] < 96) hdigit[1]= hdigit[1] - 48;
         else hdigit[1]= hdigit[1] - 87;

         temp[((len - x) / 2) - 1]= (16 * hdigit[0]) + hdigit[1];
      }
      temp[len / 2]= '\0';
      for(i= 0; i <= (len / 2); i++) hex[i]= temp[i]; 


   }else{
      strcpy(hex, hex + 1);
   }
   if(ishex) return(1);
}

