.\" $Copyright:	$
.\" Copyright (c) 1989 Robert Silvers, pRevious, Inc. 
.\" All rights reserved
.V= $Header: uzap.l 1.0 01/06/89 $
.TH UZAP LOCAL "\*(V)" "RS"
.UZAP NAME
uzap \- unix zap, a visual binary file editor.
.SH SYNOPSIS
.B uzap 
[filename]
.SH DESCRIPTION
.I Uzap 
is a general purpose interactive binary file editor.  Using this program, you 
can modify text and instructions in an otherwise inaccessible file.  This is a
full screen program that is compatable with VT100 series terminals.  When a
file is loaded, you will see both a hex, and an ascii representation of it.  
Non-printable ascii characters will appear as a '-'.  Actual hyphens will 
appear in bold.  When you load a file, the filesize will appear, and you
will be presented with a menu of commands.  You may now browse through the file
with the cursor keys.  Down-arrow will move you one 240 character page ahead, 
up-arrow will move you back.  Right-arrow will jump you to the end of the file,
left will go to the beginning.  This program was designed to take no time to
learn how to use with minimal loss of function.  Any comments and bug reports
will be appretiated.  If you have ideas for additional features (except
inserting data), please send them to me.  
.SH COMMANDS

.I Load
will read the binary image, a file could also have been specified as a
command line argument.  You must give the full path name to the file,
~username/file will not do (yet).

.I Save
will write the file back to disk.  If you just hit return, the original
filename will be used, and the original file will be overwitten.

.I Quit
will exit the program.  If the file was modified, it will ask you to
verify the quit.  On an unmodified file, it will just exit.  This is the
only way to exit, as Control-C has been disabled (the program will enter a
Control-C into the binary if you hit it while in ascii editing mode).

.I Hex edit
will edit the file in the hex window.  In this window, you may only enter
hex digits.  Use the cursor keys to move around.  If you do this to fast, as
with auto-repeat, an escape character or two may appear on the screen.
Control-L will refresh the display.  Hit ESC twice to exit this mode.  

.I Asc edit
for ascii editing mode.  You may type most characters, including control
characters.  Control-L will refresh the screen, so if you want to enter one 
of those, you must put a 0C in the hex window.  Control-S and Control-Q are 
also not enterable in the ascii window.  Backspace will not back you up, it 
will enter a backspace character into the data, use the left-arrow key if you 
make a mistake.  Hit ESC twice to return to command mode.

.I Undo!
will remove any modifications from the last edit session.  It is only a single
level undo, that is, you cannot undo the undo.

.I Goto sector
will prompt you for a sector.  Sectors are 240 characters in size.

.I Jump to byte
allows you to jump to any byte in the file.  It prompts you for an offset.
Unlike sectors which start with 1, the byte offset begins with 0.  If you 
enter an editing mode, your cursor will appear at the specified byte.

.I Table
will draw an ascii/hex chart.  This is helpful for finding the hex number
of an ascii character.  

.I >Forward search: 
Hit the greater-than key to do a forward search.  This search begins at your
current position in the file, not at the beginning.  This is a case-sensitive
search.  It was easier to program that way.  You may have spaces in the string.
Hex searches are also possible.  To find A7C02F, enter $a7c02f.  The case of the
letters is not important.  You must begin with a dollar sign, or else it will
search for the ascii string "a7c02f".  If the string is found, it will be
highlighted.  If you enter an editing mode, your position will be at the
beginning of this string.

.I <Backward search:
This is the same as a forward search, but works from your current byte offset
to the beginning of the file.

.I Continue search
will continue the last search, in the same direction, with the same string.
.SH BUGS
.I You
must hit ESC twice to exit the editing mode.  This is because the arrow keys
send ESC chars.  You need to hit it twice so that the program knows that you
want to leave, and not just move.  I hope to find a way around this some time.
.SH AUTHOR
Robert Silvers, University of Lowell. (rsilvers@hawk.ulowell.edu)
