#include "globals.h" 

/***************************************************************************/
/*                                                                         */
/*                               Uzap!                                     */
/*                                                                         */
/*        Copyright (c) 1989  Robert Silvers - pRevious, Inc.              */
/*                       -All rights reserved-                             */
/*                                                                         */
/*                 Developed at the University of Lowell                   */
/*                                                                         */
/* This software is supplied free of charge.  This software, or any part   */
/* of it, may  not  be  redistributed or otherwise made available to, or   */
/* used  by, any  other  person  without the inclusion of this copyright   */
/* notice.  This software may not be used to make a profit in any way.     */
/*                                                                         */
/* This  software  is provided with absolutely no warranty, to the extent  */
/* permitted  by  applicable  state law.  In no event, unless required by  */
/* applicable law, will the author(s) of this this software be liable for  */
/* any damages caused by this software.                                    */
/*                                                                         */
/*                                                                         */
/*          Send comments and bugs to: rsilvers@hawk.ulowell.edu           */
/***************************************************************************/
/* 01/05/89 7:41am, loaded itself, modified it's name, and saved it.       */
/***************************************************************************/


void HexE(){

int cintowin, hpos;
int hx, hy;
unsigned char c, key[4], hnum[16];

   if(loaded){

      free(head);
      head= (LINK)malloc(sizeof(ELEMENT));
      head->address= 0;
      head->prev= 0;
      head->value= 0;
      head->next= 0;

      Move(15, 24);
      PRINTB("HEX");
      PRINTM("HEX editing mode.  ESC twice returns to command mode");

      cintowin= pos - (block * 240);
      hy= cintowin / 20;  
      hpos= 2 * (cintowin - (hy * 20));
      hx= hpos + 1;
      hpos+= hpos / 8;
      Move(hy + 3, hpos + 4);


      while(1){

	 GetEscSequence(key);
	 if(key[0]==12){
	    Refresh();
            Move(15, 24);
            PRINTB("HEX");
            PRINTM("HEX editing mode.  ESC twice returns to command mode");
         }

	 if(key[0]==27){
	          if(key[2]=='A'){
	        if(hy > 0){
                   hy--; 
                   pos-= 20;
                }else{
		   if(pos > 200){
		      hy= 11;
		      pos-=20;
		      block= pos / 240;
		      Normal();
		      ShowData();
                   }
                }
	    }else if(key[2]=='C'){
                if((hx < 41) && (pos < size)){
		   hx++;
		   if((pos < size) && (hx%2)) pos++;
		   if(hy==11 && hx==41 && (pos < size)){ 
		      hx= hpos= 1;
		      hy= 0;
		      block= pos / 240;
		      Normal();
		      ShowData();
                   }
                }
	    }else if(key[2]=='B'){
		if((pos + 20) < size){
                   if(hy < 11){
		      hy++;
                      pos+= 20;
                   }else{
                      if((pos + 20) < size){
		         hy= 0;
		         pos+=20;
		         block= pos / 240;
		         Normal();
		         ShowData();
                      }
                   }
	        }
	    }else if(key[2]=='D'){
                if(hx > 0){
		   hx--;
		   if((pos > 0) && (!(hx%2))) pos--;
		   if(hy==0 && hx==0 && (pos > 200)){
		      hx= 40;
		      hy= 11;
		      block= pos / 240;
		      Normal();
		      ShowData();
                   }
                }
	    }else{
	       c= GetKey();
	       goto done;
            }
	 }

	 Bold();
	 if(isxdigit(key[0])){
	    modified=TRUE;
	    if(pos < size){

	       c= key[0];

	       head->address= pos;
	       head->value= image[pos];
	       head->next= (LINK)malloc(sizeof(ELEMENT));
	       head->next->prev= head;
	       head= head->next;
	       tail= head;
	       head->next= 0;
	       head->address= 0;

	       if(islower(c)) c=toupper(c);   /* Uppercase */
	       putchar(c);

               if(c < 64) c-= 48;
	       else c-= 55;

	       if(!(hx%2)){                  
		  image[pos]= (image[pos] >> 4); /* Right half */
		  image[pos]= (image[pos] << 4);
                  image[pos]= c | image[pos];
	       }else{
		  image[pos]= (image[pos] << 4); /* Left half  */
		  image[pos]= (image[pos] >> 4);
                  image[pos]= (c * 16) | image[pos];
	       }

	       Move(hy + 3, (((hx - 1) / 2)) + 55);
	       /* Show ascii version */
	       if(IsPrint(image[pos]))
	          putchar(image[pos]);
               else
		  putchar('-');

	       if(!(hx==40 && hy==11)){
		  hx++; 
	          if(hx%2) pos++;
               }else{
	          if(!(hx%2)) pos++; /* Two hex chars=1 byte */  
		  hpos=hx=1;
		  hy=0;     /* Next Page */
		  block= pos / 240;
		  Normal();
		  ShowData();
               }
            }
         }

         if(hx==0){ /* Left to right wrap */
	    hx=1;
	    if(hy > 0){
	       hy--;
	       hx=40;
            }
         }
         if(hx==41){ /* Right to left wrap */
	    hx=1;
	    hpos= 1;
	    if(hy < 11){
	       hy++;
            }
         }
	 Normal();
         Move(16, 61);
         printf("%d/%d       ", pos, size);

	 hpos= hx - 1;
	 hpos+= hpos / 8;
         Move(hy + 3, hpos + 4);    
      }
done:
      Normal();
      Move(15, 24);
      printf("HEX");
      PRINTM("Returning to command mode");
   }else{
      PRINTM("No file to edit");
   }
}


void AscE(){
int cintowin, hpos;
int ax, ay;
unsigned char c, key[4], hnum[16];

   if(loaded){

      /* Undo buffer stuff */
      free(head);
      head= (LINK)malloc(sizeof(ELEMENT));
      head->address= 0;
      head->value= 0;
      head->prev= 0;
      head->next= 0;

      Move(15, 63);
      PRINTB("ASC");
      PRINTM("ASC editing mode.  ESC twice returns to command mode");

      cintowin= pos - (block * 240);
      ay= cintowin / 20;  
      ax= cintowin - (ay * 20); 
      hpos= cintowin - (ay * 20);
      Move(ay + 3, ax + 55);

      while(1){

	 GetEscSequence(key);
	 if(key[0]==12){
	    Refresh();
            Move(15, 63);
            PRINTB("ASC");
            PRINTM("ASC editing mode.  ESC twice returns to command mode");
         }

	 if(key[0]==27){
	          if(key[2]=='A'){
	        if(ay > 0){
                   ay--; 
                   pos-= 20;
                }else{
		   if(pos > 200){
		      ay= 11;
		      pos-=20;
		      block= pos / 240;
		      Normal();
		      ShowData();
                   }
                }
	    }else if(key[2]=='C'){
                if((ax <= 19) && (pos < size)){
		   ax++;
		   if(pos < size) pos++;
		   if(ay==11 && ax==20 && (pos < size)){ 
		      ax= ay= 0;
		      block= pos / 240;
		      Normal();
		      ShowData();
                   }
                }
	    }else if(key[2]=='B'){
		if((pos + 20) < size){
                   if(ay < 11){
		      ay++;
                      pos+= 20;
                   }else{
                      if((pos + 20) < size){
		         ay= 0;
		         pos+=20;
		         block= pos / 240;
		         Normal();
		         ShowData();
                      }
                   }
	        }
	    }else if(key[2]=='D'){
                if(ax >= 0){
		   ax--;
		   if(pos > 0) pos--;
		   if(ay==0 && ax==-1 && (pos > 200)){
		      ax= 19;
		      ay= 11;
		      block= pos / 240;
		      Normal();
		      ShowData();
                   }
                }
	    }else{
	       c= GetKey();
	       goto done;
            }
	 }

	 Bold();
	 if((IsPrint(key[0]) || iscntrl(key[0])) && (key[0]!=27 && key[0]!=12)){
	    modified=TRUE;
	    if(pos < size){

	       head->address= pos;
	       head->value= image[pos];
	       image[pos]= key[0];   /* Put in ascii char */
	       head->next= (LINK)malloc(sizeof(ELEMENT));
	       head->next->prev= head;
	       head= head->next;
	       tail= head;
	       head->next= 0;

	       if(IsPrint(key[0]))
	          putchar(key[0]);
               else
		  putchar('-');

	       hpos= (ax + (ax - 1)) + 1;
	       hpos+= hpos / 8;
               Move(ay + 3, hpos + 4);                  /* Put in hex char */

	       sprintf(hnum, "%2x", key[0]);            /* Get HEX value   */
	       if(hnum[0]==' ') hnum[0]='0';
	       if(islower(hnum[0])) hnum[0]=toupper(hnum[0]); /* Uppercase */
	       if(islower(hnum[1])) hnum[1]=toupper(hnum[1]);
	       putchar(hnum[0]);
	       putchar(hnum[1]);

	       if(!(ax==19 && ay==11)){
	          pos++; ax++; 
               }else{
	          pos++;
		  ax=ay=0; /* Next Page */
		  block= pos / 240;
		  Normal();
		  ShowData();
               }
            }
         }
	 Normal();
         if(ax== -1){ /* Left to right wrap */
	    ax=0;
	    if(ay > 0){
	       ay--;
	       ax=19;
            }
         }
         if(ax==20){ /* Right to left wrap */
	    ax=19;
	    if(ay < 11){
	       ay++;
	       ax=0;
            }
         }
         Move(16, 61);
         printf("%d/%d       ", pos, size);
	 Move(ay + 3, ax + 55);
      }
done:
      Normal();
      Move(15, 63);
      printf("ASC");
      PRINTM("Returning to command mode");
   }else{
      PRINTM("No file to edit");
   }
} /* AscE */


void Undo(){

   if(modified){
      modified= FALSE;

      while(tail->prev!=0){
	 tail= tail->prev;
	 image[tail->address]= tail->value;
      }
      pos= tail->address;
      free(head);
      PRINTM("Undo!");
      ShowData();
   }else{
      PRINTM("Nothing to undo\n");
   }
}

