#include "globals.h" 

/***************************************************************************/
/*                                                                         */
/*                                 Uzap!                                   */
/*                                                                         */
/*                  Copyright (c) 1989  Robert Silvers                     */
/*                          -All rights reserved-                          */
/*                                                                         */
/*                 Developed at the University of Lowell                   */
/*                                                                         */
/* This software is supplied free of charge.  This software, or any part   */
/* of it, may  not  be  redistributed or otherwise made available to, or   */
/* used  by, any  other  person  without the inclusion of this copyright   */
/* notice.  This software may not be used to make a profit in any way.     */
/*                                                                         */
/* This  software  is provided with absolutely no warranty, to the extent  */
/* permitted  by  applicable  state law.  In no event, unless required by  */
/* applicable law, will the author(s) of this this software be liable for  */
/* any damages caused by this software.                                    */
/*                                                                         */
/*                                                                         */
/*          Send comments and bugs to: rsilvers@hawk.ulowell.edu           */
/***************************************************************************/
/* 01/05/89 7:41am, loaded itself, modified it's name, and saved it.       */
/***************************************************************************/


void DrawScreen(){
   echo();
   noraw();
   printf(" ");
   Inverse();
   printf(" Uzap! %s  (c) 1989 Robert Silvers -----------   --", VERSION);
   printf(" University of Lowell \n");
   Normal();
   Graphics();
   printf(" lqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqk  ");
   printf(" lqqqqqqqqqqqqqqqqqqqqqqk\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" x\t\t\t\t\t\tx   x\t\t\t   x\n");
   printf(" mqqqqqqqqqqqqqqqqqqqqqHEXqqqqqqqqqqqqqqqqqqqqqqj  ");
   printf(" mqqqqqqqqqASCqqqqqqqqqqj\n\n");
   Asc();
   printf("   Filespec: \n\n");
   printf("   Messages: \n");
   PRINTG (" lqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq");
   PRINTG ("qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqk\n");
   PRINTG(" x "); PRINTB("L"); printf("oad           ");
   PRINTB (" H"); printf("ex edit         ");
   PRINTB (" G"); printf("oto sector         ");
   PRINTB (" >"); printf("Forward  search "); PRINTG("x\n");
   PRINTG (" x "); PRINTB("S"); printf("ave           ");
   PRINTB (" A"); printf("sc edit         ");
   PRINTB (" J"); printf("ump to byte        ");
   PRINTB (" <"); printf("Backward search "); PRINTG("x\n");
   PRINTG (" x "); PRINTB("Q"); printf("uit           ");
   PRINTB (" U"); printf("ndo!            ");
   PRINTB (" T"); printf("able               ");
   PRINTB (" C"); printf("ontinue  search "); PRINTG("x\n");
   PRINTG (" mqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq");
   PRINTG ("qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqj");
   fflush(stdout);
   ShowData();
   noecho();
   raw();
} /* DrawScreen */


void Table(){
char c;

   echo();
   noraw();
   Cls();
   printf("  ");
   Inverse();
   printf("CHR DEC HX   CHR DEC HX   CHR DEC HX   CHR DEC HX   ");
   printf("CHR DEC HX   CHR DEC HX"); 
   Normal();
   printf("  \n");
   printf("  nul 000 00 | syn 022 16 |  ,  044 2C |  B  066 42 | ");
   printf(" X  088 58 |  n  110 6E  \n");
   printf("  soh 001 01 | etb 023 17 |  -  045 2D |  C  067 43 | ");
   printf(" Y  089 59 |  o  111 6F  \n");
   printf("  stx 002 02 | can 024 18 |  .  046 2E |  D  068 44 | ");
   printf(" Z  090 5A |  p  112 70  \n");
   printf("  etx 003 03 | em  025 19 |  /  047 2F |  E  069 45 | ");
   printf(" [  091 5B |  q  113 71  \n");
   printf("  eot 004 04 | sub 026 1A |  0  048 30 |  F  070 46 | ");
   printf(" \\  092 5C |  r  114 72  \n");
   printf("  enq 005 05 | esc 027 1B |  1  049 31 |  G  071 47 | ");
   printf(" ]  093 5D |  s  115 73  \n");
   printf("  ack 006 06 | fs  028 1C |  2  050 32 |  H  072 48 | ");
   printf(" ^  094 5E |  t  116 74  \n");
   printf("  bel 007 07 | gs  029 1D |  3  051 33 |  I  073 49 | ");
   printf(" _  095 5F |  u  117 75  \n");
   printf("  bs  008 08 | rs  030 1E |  4  052 34 |  J  074 4A | ");
   printf(" `  096 60 |  v  118 76  \n");
   printf("  ht  009 09 | us  031 1F |  5  053 35 |  K  075 4B | ");
   printf(" a  097 61 |  w  119 77  \n");
   printf("  nl  010 0A | sp  032 20 |  6  054 36 |  L  076 4C | ");
   printf(" b  098 62 |  x  120 78  \n");
   printf("  vt  011 0B |  !  033 21 |  7  055 37 |  M  077 4D | ");
   printf(" c  099 63 |  y  121 79  \n");
   printf("  np  012 0C |  \"  034 22 |  8  056 38 |  N  078 4E | ");
   printf(" d  100 64 |  z  122 7A  \n");
   printf("  cr  013 0D |  #  035 23 |  9  057 39 |  O  079 4F | ");
   printf(" e  101 65 |  {  123 7B  \n");
   printf("  so  014 0E |  $  036 24 |  :  058 3A |  P  080 50 | ");
   printf(" f  102 66 |  |  124 7C  \n");
   printf("  si  015 0F |  %c  037 25 |  ;  059 3B |  Q  081 51 | ", 37);
   printf(" g  103 67 |  }  125 7D  \n");
   printf("  dle 016 10 |  &  038 26 |  <  060 3C |  R  082 52 | ");
   printf(" h  104 68 |  ~  126 7E  \n");
   printf("  dc1 017 11 |  '  039 27 |  =  061 3D |  S  083 53 | ");
   printf(" i  105 69 | del 127 7F  \n");
   printf("  dc2 018 12 |  (  040 28 |  >  062 3E |  T  084 54 | ");
   printf(" j  106 6A |\n");
   printf("  dc3 019 13 |  )  041 29 |  ?  063 3F |  U  085 55 | ");
   printf(" k  107 6B |\n");
   printf("  dc4 020 14 |  *  042 2A |  @  064 40 |  V  086 56 | ");
   printf(" l  108 6C |\n");
   printf("  nak 021 15 |  +  043 2B |  A  065 41 |  W  087 57 | ");
   printf(" m  109 6D |\n");
   printf("  Hit space to continue");
   noecho();
   raw();
   while((c= GetKey())!=32);
   Refresh();
   PRINTM("Waiting for command");
}


int ShowData(){
unsigned char c, hnum[16];
int x, y;

   if(!loaded) return(0);

   Move(16, 31);
   printf("Sector: %d/%d          ", block + 1, max + 1);
   Move(16, 53);
   printf("Offset: %d/%d       ", pos, size);

   for(y= 0; y < 12; y++){                    
      Move(y + 3, 4);
      for(x= 0; x < 20; x++){
	 if(((block * 240) + x + (y * 20)) >= size){
	    putchar('#');
	    putchar('#');
            if(!((x + 1)%4)) putchar(' ');
         }else{
            c= image[(block * 240) + x + (y * 20)];
	    sprintf(hnum, "%2x", c);       /* Get HEX value */
	    if(hnum[0]==' ') hnum[0]='0';
	    if(islower(hnum[0])) hnum[0]=toupper(hnum[0]);
	    if(islower(hnum[1])) hnum[1]=toupper(hnum[1]);
	    putchar(hnum[0]);
	    putchar(hnum[1]);
            if(!((x + 1)%4)) putchar(' ');
         }/* if */
      } /* for */

      Move(y + 3, 55);
      for(x= 0; x < 20; x++){
	 if(((block * 240) + x + (y * 20)) >= size)
	    putchar('#');
         else{
            c= image[(block * 240) + x + (y * 20)];
	    if(IsPrint(c)){
	       if(c=='-'){
	          Bold();
	          putchar('-');
	          Normal();
               }else
	          putchar(c);
            }else{
	       putchar('-');
            } /* if */
         } /* if */
      } /* for */ 
   } /* for */
   Home();
} /* ShowData */


/* isprint() thinks a tab is a printable character.  Not good.  */
int IsPrint(chr)
unsigned char chr;{

   if(((chr > 31 && chr < 127) || (chr > 159 && chr < 255)) && isprint(chr)
        && chr!=27)
      return(1);
   else
      return(0);
}


void Refresh(){

   Cls();
   DrawScreen();
   Move(17, 14);
   printf("%s               ", dfilename);
   Move(19, 14);
}


/* Various screen control functions */

void Move(y, x)
int x, y;{

   printf("\033[%d;%dH", y, x);

}
void Cls(){
   printf("\033[H\033[2J");
}
void CHome(){
   Move(19, 14);
   printf("                                                                 ");
   Move(19, 14);
}
void Home(){
   Move(19, 14);
}
void Bold(){
   printf("\033[1m"); 
}
void Blink(){
   printf("\033[5m"); 
}

void Underline(){
   printf("\033[4m"); 
}

void Inverse(){
   printf("\033[7m"); 
}

void Normal(){
   printf("\033[0m"); 
}

void Graphics(){
   printf("\033(0\0331");    
}

void Asc(){
   printf("\033(B\0332"); 
}

void Beep(){
   putchar(7);
}
void abort(){
}
void cont(){
   Refresh();
}

