/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"    /* just for the #define of a NULL */
#include "externs.h" /* for the strings things. */

/* append  s2 unto s1, returning a pointer to the new "end" of s1 */
char *
strappend(s1, s2)
char *s1, *s2;
{
	register char *p, *r;
	p = s1;
	r = s2;
	do {
		*(p++) = *r;
	} while ( *(r++) != '\0');
	p--;
	return(p);
}
/* return a pointer to the first occurence of s2 in s1 otherwise NULL */
char *
strindex(s1, s2)
char *s1, *s2;
{
	register char *p, *s;
	register int len;
	p=s1;
	len = strlen(s2);
	/* quick test to blow away short lines */
	if (len > strlen(s1))
		return(NULL);
	while ((s=STRCHR(p, *s2)) != NULL) {
		if (!strncmp(s, s2, len))  {
			return(s);
		}
		p= (++s);
	}
	return(NULL);
}
long
makenum(buf)
char *buf;
{
	switch (*buf) {
		case '\0':
			return(-1L);
		break;
		case '$':
			return(NumberLines);
		break;
		case '^':
			return(1L);
		break;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			return(atol(buf) > 1L ? atol(buf) : 1L);
		break;
		default:
			return(-1L);
	}
	return(-1L);
}
help()
{
	register int input, amount;
	if ((input = open (HelpName, O_RDONLY)) < 0) {
		fprintf(stderr, "%s: Could not open file \"%s\"",
		    Progname, HelpName);
		perror("");
		return(!OK);
	}
	while((amount=read(input, buf, BUFSIZ)) > 0)
		write(1, buf, amount);
	close(input);
	return(OK);
}
