
/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"
#include "externs.h"

#define RANGE(x)	(x > 0 && x <= NumberLines)
static char *Start="Starting line number ";
static char *End=  "  Ending line number ";
multi_change()
{
	long start, end, count;
	char *string="for changes :";
	fputs(Start, stdout);
	fputs(string, stdout);
	start=getlnum();
	if (!RANGE(start)) 
		return(!OK);
	fputs(End, stdout);
	fputs(string, stdout);
	end=getlnum();
	if (!RANGE(end))
		return(!OK);
	for(count = start ; count <= end ; count++) 
		change(count);
	return(OK);
}
multi_delete()
{
	long start, end, count;
	char *string="to delete : ";
	fputs(Start, stdout);
	fputs(string, stdout);
	start=getlnum();
	if (!RANGE(start)) 
		return(!OK);
	fputs(End, stdout);
	fputs(string, stdout);
	end=getlnum();
	if (!RANGE(end))
		return(!OK);
	for(count = end ; count >= start ; count--) 
		subtract(count);
	return(OK);
}
multi_print()
{
	long start, end, count;
	char *string="to be printed : ";
	fputs(Start, stdout);
	fputs(string, stdout);
	start=getlnum();
	if (!RANGE(start)) 
		return(!OK);
	fputs(End, stdout);
	fputs(string, stdout);
	end=getlnum();
	if (!RANGE(end))
		return(!OK);
	for(count = start ; count <= end ; count++) 
		printline(count);
	return(OK);
}
