	
/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"
#include "externs.h"

#define __FILE__	"mem.c"

clear_stuff()
{
	LINE *temp, *next;
	if (l_start != (LINE *) NULL) {
		/* something inside, clear 'em out */
		for (temp = l_end; temp != l_start ;) {
			next = temp->previous;
			free(temp);
			temp = next;
		}
	}
	l_start = (LINE *) malloc(sizeof(LINE) + 2);
	l_start -> previous 	= (LINE *) NULL;
	l_start -> next		= (LINE *) NULL;
	l_end 			= l_start;
	current			= l_start;
	CurrentLine		= 0L;
	NumberLines		= 0L;
}
long
loadem(inputfile, place)
FILE *inputfile;
long place;
{
	while ((fgets(buf, BUFSIZ, inputfile)) != NULL) {
		if(add(buf, place++) != OK) {
			fprintf(stderr, "%s:%d loadem() add() failure\n", 
				__FILE__, __LINE__);
			return(!OK);
		}
		if (Dots == 'Y' || Debug) {
			putchar('.');
			fflush(stdout);
		}
	}
	putchar('\n');
	return(NumberLines);
}
LINE *
setline(number)
long number;
{
	LINE *tmp;
	tmp=getline(number);
	if (tmp != (LINE *) NULL)  {
		CurrentLine = number;
		current = tmp;
	}

	return(tmp);
}
LINE *
getline(number)
long number;
{
	LINE *inc;
	long i;
	if (number > NumberLines) {
		printf("%s-%s: getline(%ld) > NumberLines == %ld\n",
			Progname, __FILE__, number, NumberLines);
		return((LINE *)NULL);
	}
	if (number == 0L) 
		return(l_start);
	for (i=1L, inc=l_start; i<number ; i++, inc=inc->next);
	return(inc);
}
printline(number)
long number;
{
	LINE *tmp;
	if ((tmp=setline(number)) != (LINE *) NULL) {
		fputs(tmp->text, stdout);
		fflush(stdout);
		return(OK);
	}
	fprintf(stderr, "%s: printline(%ld) Bad line number\n", __FILE__, number);
	fflush(stderr);
	return(!OK);
}



add(buf, number)
char *buf;
long number;
{
	LINE *new, *temp;
	if (Debug) printf("add(%ld)\n", number);
	new = (LINE *) malloc(sizeof(LINE) + strlen(buf));
	if (number > 0L) {
		temp=getline(number);
		if (temp == (LINE *) NULL)  {
			fprintf(stderr, "%s: add(%ld) bad line number\n",
				__FILE__, number);
			return(!OK);
		}
		new -> previous = temp;
		if (temp->next != (LINE *) NULL)  {
			temp->next->previous = new;
			new -> next = temp->next;
		} else {
			new->next = (LINE *) NULL;
			l_end = new;
		}
		temp -> next = new;
	} else {
		new -> previous = (LINE *) NULL;
		if (NumberLines < 1L) {
			new -> next = (LINE *) NULL;
			l_end = new;
		} else 
			new -> next = l_end;

		/* Now, blow away anything nasty, still hanging around */
		if (l_start != (LINE *) NULL)
			free(l_start); 

		l_start = new;
		current = new;
	}
	/* make sure line has a newline on the end.. */
	if (buf[strlen(buf)-1] != '\n')
		strcat(buf, "\n");
	strcpy(new->text, buf);
	NumberLines++;
	current=new;
	CurrentLine=NumberLines;
	return(OK);
}
subtract(number)
long number;
{
	LINE *tmp;
	tmp = getline(number);
	if (tmp == (LINE *)NULL) {
		fprintf(stderr, "%s: subtract(%ld) bad line number\n", 
			__FILE__, number);
		return(!OK);
	}
	if (l_end == tmp) {
		l_end = l_end -> previous;
	}
	if (tmp -> previous != (LINE *) NULL) 
		tmp -> previous -> next = tmp -> next; 
	 else {
		if (tmp -> next != (LINE *) NULL) {
			tmp -> next -> previous = (LINE *) NULL;
			l_start = tmp -> next;
		}
	}

	if (tmp -> next != (LINE *) NULL)
		tmp -> next -> previous  = tmp -> previous;
	 else {
		if (tmp -> previous != (LINE *) NULL) {
			tmp -> previous -> next = (LINE *) NULL;
			l_end = tmp -> previous;
		}
	}
	if (NumberLines-- > 1L)
		free(tmp);
	current=setline(number < NumberLines ? number : NumberLines);
	return(current != (LINE *) NULL ? OK : !OK);
}
	
replace(number, buf)
char *buf;
long number;
{
	LINE *old, *new;
	old=getline(number);
	if (old == (LINE *) NULL)  {
		fprintf(stderr, "%s: replace(%ld) bad line number\n", __FILE__, number);
		return(!OK);
	}
	new = (LINE *) malloc(sizeof(LINE) + strlen(buf));
	new -> previous		= old -> previous;
	new -> next		= old -> next;
	if (new -> previous != (LINE *) NULL)  
		new -> previous -> next = new;
	else 
		l_start = new;

	if (new -> next != (LINE *) NULL)  
		new -> next -> previous = new;
	else 
		l_end = new;

	if (STRCHR(buf, '\n') == NULL)
		strcat(buf, "\n");
	strcpy(new->text, buf);
	free(old);
	current=setline(number);
	return(current != (LINE *) NULL ? OK : !OK );
}
srch_n_replace(number, old_str, new_str, glob)
long number;
char *old_str, *new_str;
char glob;
{
	LINE *work;
	char *p, *b, *buff;
	int len_old, cnt=0;
	work = getline(number);
	if (work == (LINE *) NULL) {
		fprintf(stderr, "%s: srch_n_replace(%ld) bad line number\n",
			__FILE__, number);
		return(!OK);
	}
	len_old = strlen(old_str);
	buff = malloc(MAXREPLACE);
	if (buff == NULL)
		return(!OK);
	p=work->text;
	b=buff;
	do {
		cnt++;
		if (*p == *old_str)  {
			if (!strncmp(p, old_str, len_old)) {
				p += (len_old-1); /* advance past string */
				b = strappend(b, new_str);
				if (glob == 'N')  {
					p++;
					strcat(b, p);
					break;
				}
			} else
			*(b++) = *p;
		} else 
			*(b++) = *p;
	} while ((*(p++) != '\0') && cnt < MAXREPLACE);
	replace(number, buff);
	free(buff);
	return(OK);
}
saveem(file)
char *file;
{
	LINE *work;
	int out;
	long count=0L;
	out = open(file, O_WRONLY | O_CREAT | O_TRUNC, 0666);
	if (out < 0) {
		fprintf(stderr, "%s: Could not open \"%s\" for writing",
			Progname, file);
		perror("");
		return(!OK);
	}
	work = l_start;
	while (work != (LINE *) NULL && count < NumberLines)  {
		count++;
		write(out, work->text, strlen(work->text));
		work = work-> next;
		if (WriteOnQuit != 'Y') putchar('.');
	}
	close(out);
	putchar('\n');
	return(OK);
}
