
/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"
#include "externs.h"

main(argc, argv)
int argc;
char **argv;
{
	int c;
	char start_line[80];
	extern char *optarg;
	extern int optind, opterr;
	opterr=1;
	Progname = *argv;
#ifndef MSDOS
	savetty();
	initscr();
#endif MSDOS
	signal(SIGINT, SIG_IGN);
	while ((c=getopt(argc, argv, "Dwa:")) != EOF) {
		switch (c) {
		case 'D': Debug = 1;			break;
		case 'a': strcpy(start_line,optarg);	break;
		case 'w': WriteOnQuit='Y';		break;
		}
	}
	if (Debug) printf("extra args %d\n", optind);
	if (argc < 2) {
		fprintf(stderr, "%s: usage: %s [options] file [ file file]\n",
				Progname, Progname);
		exit(-1);
	}
	for (;optind < argc; optind++) {
		errno=0;
		edit(argv[optind], start_line);
		*start_line = '\0';
	}
	resetty();
	exit(errno);
}

edit(file, sline)
char *file;
char *sline;
{
	struct stat stbuff, *s;
	char c;
	int new=!OK;
	s=(struct stat *) &stbuff;
	clear_stuff();
	noecho();
	One_Char();
	if ((EditFile=fopen(file, "r")) == (FILE *) NULL) {
		if (errno == ENOENT) {
			printf("File %s doesn't exist, create (y/n) ? ",
				file);
			c=yesno();
			switch(c) {
				case 'Y':
					close(creat(file, 0666));
					if ((EditFile=fopen(file, "r")) == (FILE *) NULL) {
						/* give up... */
						fprintf(stderr, "%s: could not create %s\n", Progname, file);
						return(!OK);
					}
					new=OK;
					break;
				case 'N':
				default:
					return(OK);
					break;	
			}
		} else {
		fprintf(stderr, "%s: Could not read %s",
			Progname, file);
			perror("");
			return(!OK);
		}
	}
	if (fstat(fileno(EditFile), s) < 0) {
		fprintf(stderr, "%s: fstat(%d) failed",
			Progname, fileno(EditFile));
			perror("");
			return(!OK);
		}
	if (s->st_size > BEGINDOTS)
		Dots = 'Y';
	if (new != OK && s->st_size > 0L)  {
		if (loadem(EditFile, 0L) > 0L) {
			printf("File: \"%s\"   lines=%ld, charicters=%ld\n",
				file, NumberLines, s->st_size);
			fclose(EditFile);
			command(file, sline);
		}
	} else {
		printf("File: \"%s\" is new, begin entering new text\n", file);
		append(0L);
		command(file, "\0");
	}
	return(OK);
}
