
/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"
#include "externs.h"

#define __FILE__	"find.c"

long
find(c)
char c;
{
	if (find_work == (LINE *) NULL || find_line >= NumberLines) {
		puts(Eof);
		reset_find();
		return(-1L);
	}
	while (find_work != (LINE *) NULL) {
		if (strindex(find_work->text, find_string) != NULL) {
			CurrentLine=find_line;
			if (c == 'v') printline(CurrentLine);
			find_work = find_work -> next;
			find_line++;
			return(CurrentLine);
		}
		find_work = find_work -> next;
		find_line++;
	}
	puts(Eof);
	return(-1L);
}
reset_find()
{
	find_work = l_start;
	find_line = 1L;
}
setfind(number, string)
long number;
char *string;
{
	if (find_string != NULL)
		free(find_string);
	find_string = malloc(strlen(string) + 1);
	if (find_string == NULL) {
		fprintf(stderr, "%s: malloc(%d) failed\n", __FILE__,
				strlen(string));
		return(!OK);
	}
	strcpy(find_string, string);
	find_line = number;
	find_work = setline(find_line);
	return(find_work != (LINE *) NULL ? OK : !OK);
}
