
/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"
#include "externs.h"

append(number)
long number;
{
	puts("Enter a single period on a blank line to return to the editor");
	for (;;number++) {
		getstring(buf, BUFSIZ, '\0');
		if (*buf == '.' && strlen(buf) == 1) 
			return(OK);
		add(buf, number);
	}
}
		
change(number)
long number;
{
	printf("Currently line %ld looks like:\n", number);
	printline(number);
	printf("Type the new line %ld\n", number);
	getstring(buf, BUFSIZ, '\0');
	if (*buf == '.' && strlen(buf) == 1)  {
		puts("Aborted.");
		return(!OK);
	}
	return(replace(number, buf));
}
srchrep(number)
long number;
{
	char old[81], new[81], c='\0';
	printf("Line %ld looks like :\n", number);
	printline(number);
	fputs("     Search string: ", stdout);
	if (getstring(old, 81, '\0') == NULL)
		return(!OK);
	fputs("Replacement string: ", stdout);
	if (getstring(new, 81, '\0') == NULL)
		return(!OK);
	while (c != 'N' && c != 'Y') {
		fputs("Global replacement? ", stdout);
		c=getchar();
		if (islower(c)) 
			c=toupper(c);
		if (c == '\n') 
			c='N';
		switch(c) {
			case 'N':
				puts("No.");
			break;
			case 'Y':
				puts("Yes.");
			break;
			case 'Q':
				return(!OK);
			break;
			default:
				fputs("\007<Y>es, <N>o or <Q>uit please.\n", stdout);
			break;
		}
	}
	srch_n_replace(number, old, new, c);
	printline(number);
	return(OK);
}
go_fish(number)
long number;
{
	char sstring[81];
	fputs("String to search for : ", stdout);
	if(getstring(sstring, 80, '\0') == NULL)
		return(!OK);
	if (setfind(number, sstring) == OK) 
		return(find('v') > 0L ? OK : !OK);
	return(!OK);
}
go_global(number)
long number;
{
	char old[81], new[81];
	fputs("     Search string: ", stdout);
	if (getstring(old, 80, '\0') == NULL)
		return(!OK);
	fputs("Replacement string: ", stdout);
	if (getstring(new, 80, '\0') == NULL)
		return(!OK);
	return(global_replace(number, old, new));
}
global_replace(number, old, new)
long number;
char *old, *new;
{
	long line, count=0L;
	if (setfind(number, old) == OK) {
		while ((line=find('n')) > 0L)  {
			if (srch_n_replace(line, old, new, 'Y') == OK) 
				count++;
		}
		printf("Replaced \"%s\" with \"%s\" %ld times.\n",
			old, new, count);

		return(count > 0L ? OK : !OK);
	}
	return(!OK);
}
insert(number)
long number;
{
	number--;
	return(append(number));
}
