
/*
 * This code copyright 1988 by Doug Davis (doug@letni.lawnet.com) 
 *  You are free to modify, hack, fold, spindle, or mutlate this code in
 *  any maner provided you give credit where credit is due and don't pretend
 *  you wrote it.
 *  If you do my lawyers (and I have a lot of lawyers) will teach you a lesson
 *  in copyright law that you will never ever forget.
 */
#include "defs.h"
#include "externs.h"

command(file, sline)
char *file;
char *sline;
{
	char c;
	long start;
	char changed='N';
	if (*sline != '\0') {
		start=makenum(sline);
		fputs("appending ", stdout);
		if (start >= NumberLines) 
			fputs("to the bottom", stdout);
		else 
			printf("below line %ld", start);
		puts(", enter text now:");
		append(start <= NumberLines ? start : NumberLines);
		start=NumberLines;
	} else
		start = 1L;
	
	if (NumberLines > 0L)
		setline(start);
	for (;;) {
		if (NumberLines < 1L || CurrentLine < 1L) {
			puts("Buffer empty, begin entering new text.");
			append(0L);
			continue;
		}
		if (Debug) {
			printf("address             l_start: 0x%lx\n",
				l_start);
			printf("address             current: 0x%lx\n",
				current);
			printf("address               l_end: 0x%lx\n",
				l_end);
			printf("address l_start -> previous: 0x%lx\n", 
				l_start->previous);
			printf("address       l_end -> next: 0x%lx\n",
				l_end->next);
		}
		printf("Line %ld>", CurrentLine);
#ifdef MSDOS
		c=getch();
#else 
		c=getchar();
#endif MSDOS
		switch(c) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				fputs("Enter new line :", stdout);
				getstring(buf, 10, c);
				if ((start=makenum(buf)) > 0L && 
						start <= NumberLines) {
					if (setline(start) == (LINE *) NULL) 
						puts("Sorry..");
				}
				break;
			case '+':
			case ';':
				putchar('\n');
				if (CurrentLine < NumberLines) {
					CurrentLine++;
					printline(CurrentLine);
				} else
					puts(Bottom);
				break;
			case '-':
				putchar('\n');
				if (CurrentLine > 1) {
					CurrentLine--;
					printline(CurrentLine);
				} else 
					puts(Top);
				break;
			case '$':
				putchar('\n');
				CurrentLine = NumberLines;
				setline(CurrentLine);
				puts(Bottom);
				break;
			case '^':
				putchar('\n');
				CurrentLine = 1L;
				setline(CurrentLine);
				puts(Top);
				break;
			case 'C':
				puts("Change lines.");
				multi_change();
				changed = 'Y';
				break;
			case 'D':
				puts("Delete lines.");
				multi_delete();
				changed = 'Y';
				break;
			case 'P':
				puts("Print.");
				multi_print();
				break;
			case 'a':
				printf("Appending after line # %ld\n", CurrentLine);
				append(CurrentLine);
				changed = 'Y';
				break;
			case 'c':
				printf("Change line # %ld\n", CurrentLine);
				change(CurrentLine);
				changed = 'Y';
				break;
			case 'd':
				printf("Deleted line # %ld\n", CurrentLine);
				subtract(CurrentLine);
				changed = 'Y';
				break;
			case 'f':
			case '/':
				puts("Find string.");
				go_fish(CurrentLine);
				break;
			case 'g':
				puts("Global.");
				go_global(CurrentLine);
				changed = 'Y';
				break;
			case 'i':
				printf("Inserting before line %ld.\n", CurrentLine);
				insert(CurrentLine);
				changed = 'Y';
				break;
			case 'n': /* next occurence */
				puts("Next.");
				find('v');
				break;
			case 'p':
				puts("print.");
				printline(CurrentLine);
				break;
			case 'q':
				puts("quit.");
				if (WriteOnQuit == 'Y') {
					if(saveem(file) == OK) {
						return(OK);
					} else {
						fprintf(stderr, "%s: Write on quit set, but save failed.\n", Progname);
						WriteOnQuit='N';
						break;
					}
					
				}
				if (changed == 'Y') {
					fputs("File changed, are you sure (y/n) ? ", stdout);
					c=yesno();
					if (c == 'N') 
						break;
				}
				return(OK);
				break;
			case 's':
				puts("search/replace");
				srchrep(CurrentLine);
				changed = 'Y';
				break;
			case 'w':
				puts("Saveing.");
				saveem(file);
				changed = 'N';
				break;
			case '?':
				puts("Help.");
				help();
				break;
			default:
				puts("? - for help");
				break;
				
		}
	}
}
