/*
 * Name:	Mg 2b
 *		MSDOS terminal I/O (TurboC 1.5)
 *
 * The functions in this file
 * negotiate with the operating system for
 * keyboard characters, and write characters to
 * the display
 *
 * This version goes along with tty/ibmbios/tty.c.
 * Terminal size is determined there, rather than here.
 */
#include	"def.h"

#include	<stdio.h>
#include	<fcntl.h>
#include	<signal.h>

static int ttyactivep = FALSE;		/* terminal in editor mode?	*/

int	nrow;				/* Terminal size, rows.		*/
int	ncol;				/* Terminal size, columns.	*/

/*
 * This function gets called once, to set up
 * the terminal channel.  This is essentially a no-op
 * on msdos, since I/O will all be done via bios calls.
 */
ttopen()
{
	if (ttyactivep)
		return;

	signal(SIGINT, SIG_IGN);

	nrow = 25;			/* initial guess */
	ncol = 80;

	ttyactivep = TRUE;
}

/*
 * This function gets called just
 * before we go back home to the shell. Another
 * MSDOS no_op.
 */
ttclose()
{
	if(!ttyactivep)
		return;
	ttyactivep = FALSE;
}

/********************************************************************/
/* ttputc, ttgetc & typeahead have been deleted from this file, and */
/* moved into the tty specific code.  There is no operating-system  */
/* generic way to do these                                          */
/********************************************************************/

/*
 * Flush output.  This function is a no-op
 */
ttflush()
{
}

/*
 * panic:  print error and die, leaving core file.
 */
panic(s)
char *s;
{
	fprintf(stderr, "%s\r\n", s);
#ifdef SYSCLEANUP
	SYSCLEANUP;
#endif
	exit(1);
}


/*
** This should check the size of the window, and reset if needed.
*/

setttysize()
{
	nrow = 25;
	ncol = 80;
}


void interrupt donothing()
    {
    return;	/* continue program */
    }

/* Turbo C does not have a "signal" function. */
/* since all I need to use it for is to ignore ^C, this substitute works ok */
signal(sig, action)
int sig;
int (*action)();
    {
    if (sig != SIGINT || action != SIG_IGN)
	{
	printf("Runtime error in signal: only SIGINT, SIG_IGN supported!\n");
	exit(1);
	}
    setvect(0x23, donothing);
    }
