/*
 * vdd - visual directory display (C) 1988 (pulsar@lsrhs) Jim King
 *
 * init - contains init() which is called first by main ..
 *        contains sinit() which inits the curses screen
 *        Use init() to setup any local things or SIGNALS.
 */

#include "vars.h"

extern int	cleanup(), cleanupwoc(), stopme();

sinit()
{
	noecho();
	crmode();
	err = newwin(1, 80, 0, 0);
	hlp = newwin(10, 30, 10, 50);
	dnm = newwin(1, strlen(dname), 12, 0);
	fils = newwin(22, (50 - strlen(dname) + 3), 1, strlen(dname)+3);
	fst = newwin(10, 30, 1, 50);
	refresh();
	scrollok(err, FALSE);
	scrollok(hlp, FALSE);
	scrollok(dnm, FALSE);
	scrollok(fils, FALSE);
	scrollok(fst, FALSE);
}

init()
{
	signal(SIGINT, cleanup);	/* ^C */
	signal(SIGTERM, cleanupwoc);	/* -TERM */
	signal(SIGHUP, cleanup);	/* ^D */
	signal(SIGSTOP, cleanupwoc);	/* -STOP */
	signal(SIGTSTP, stopme);	/* ^Z */
	signal(SIGSEGV, cleanup);	/* Segmentation Violation */
}
