/*
 * vdd - visual directory display (C) 1988 (pulsar@lsrhs) Jim King
 *
 * main.c - contains
 *		main() - the main program
 *		posy() - A nice screen print utility
 */

#include "vars.h" 		/* This includes everything else */

main(argc, argv)
int	argc;
char	*argv[];
{
	initscr();
	init(); /* Signal initialization routine */

	if (argc != 2)
		printf("vdd: usage: vdd directory\n"), exit(2);

/* Lets make sure the file is there */
		if (open(argv[1], O_RDONLY) == NULL) {
		perror(argv[1]); 
		exit(2);
	}

/* Throw argv[1] stat entry into l[0].f */
	if (stat(argv[1], &l[0].f) == -1) {
		perror(argv[1]);
		exit(2);
	}

	if (l[0].f.st_mode & 0000004)
		goto jm1;
	else {
		printf("vdd: directory %s is unreadable.\n", argv[1]);
		exit(1);
	}

jm1:	switch(l[0].f.st_mode & S_IFMT) {
		case S_IFDIR:
			strcpy(dname, argv[1]);
			if (strncmp(dname, "/\0", 2) != 0)
				strncat(dname, "/\0", 2);
			break;
		default:
			printf("vdd: usage: vdd directory\n"), exit(2);
			break;
	}

	sinit();
	readin();

	redraw();
	disp(); /* Main display routine */
}

/* POSY - Position Y.. Variables
 *	w - window - WINDOW *w defined in vars.h 
 * 	a - Line position
 *	b - Column position
 *	c - Reverse image (YES or NO)
 *	foo - string to print
 */

posy(w, a, b, foo, c)
int	a, b, c;
char	*foo;
{
	if (c)
		wstandout(w);
	wmove(w, a, b);
	wprintw(w, foo);
	wclrtoeol(w);
	wstandend(w);
	refresh();
	wrefresh(w);
}

/* POSYF - posy for the fils window .. -1 */

posyf(w, a, b, foo, c)
int	a, b, c;
char	*foo;
{
	if (c)
		wstandout(w);
	wmove(w, a-1, b);
	wprintw(w, foo);
	wclrtoeol(w);
	wstandend(w);
	refresh();
	wrefresh(w);
}
