/*
 * vdd - visual directory display (C) 1988 (pulsar@lsrhs) Jim King
 *
 * readin.c - contains readin() which reads in dirs
 */

#include "vars.h"

readin()
{
	total = 0;
	if ((dir = opendir(dname)) == NULL)
		printf("Cannot open dir %s\n", dname), exit(1);
	while ((ent = readdir(dir)) != NULL) {
		total++; /* Just in case I ever need it */
		sprintf(str, "%s/%s", dname, ent->d_name);
		if (stat(str, &l[total].f) == -1) {
			perror(ent->d_name);
			exit(2);
		}
		strcpy(l[total].name, ent->d_name);
		switch(l[total].f.st_mode & S_IFMT) {
			case S_IFDIR:
				l[total].dir = YES;
/* fudge */			if (strncmp(l[total].name, "/\0", 2) != 0)
					strncat(l[total].name, "/\0", 2);
				break;
			default:
				l[total].dir = NO;
				break;
		}
	}
	closedir(dir); /* Directory(3) */
	for (i = total+1; i < total+40; i++) {
		strncpy(l[i].name, "\0", 1);
		l[i].dir = NO;
	}
}
