/*
 * vdd - visual directory display (C) 1988 (pulsar@lsrhs) Jim King
 *
 * disp.c - contains
 *		Redraw subroutine dlev();
 *		Main program loop disp();
 *		Strp function turns /tmp/jove/../ into /tmp/
 */

#include "vars.h"
#include <time.h>
#include <pwd.h>
#include <grp.h>

#define USRGROUP

struct passwd *getpwuid(), *pwd;
struct group  *getgruid(), *grp;

char	*strcpy();

extern char	*rindex();

char *strp(ln)
char	*ln;
{
	char	*p = &ln[strlen(ln) - 1];

	if (*p = '/')
		*p = (char) 0;

	if ((p = rindex(ln, '/')) != (char *) 0)
		*p = (char) 0;

	return ln;
}

disp()
{
	struct stat	fil;
	char	buf[10];
	int	mult;

	ypos = lasty = 1;

	for (;;) {
		mult = (level * 22);
		wclear(err);
		posyf(fils, lasty, 0, l[lasty+mult].name, NO);
		posyf(fils, ypos, 0, l[ypos+mult].name, YES);
		lasty = ypos;
		c = getchar();
		switch (c) {
			case 'd': /* DIVE RIGHT IN */
				if (strcmp(l[ypos+mult].name, "./") == 0) {
					wmove(err, 0, 0);
					wprintw(err, "Already there!");
					refresh();
					wrefresh(err);
					break;
				}
				if (strcmp(l[ypos+mult].name, "../") == 0) {
					sprintf(str, "%s%s", dname, l[ypos+mult].name);
					strcpy(dname, strp(strp(str)));
					strncat(dname, "/\0", 2);
					goto lo2;
				}
				if (l[ypos+mult].dir) {
					if (l[ypos+mult].f.st_uid == getuid()) {
						if (l[ypos+mult].f.st_mode & 0000400)
							goto cont;
						else
							goto nop;
					}
					if (l[ypos+mult].f.st_mode & 0000004)
						goto cont;
					else {
nop:						wmove(err, 0, 0);
						wprintw(err, "Directory is unreadable.\007");
						refresh();
						wrefresh(err);
						break;
					}
cont:					sprintf(str, "%s%s", dname, l[ypos+mult].name);
					strcpy(dname, str);
				} else {
					wmove(err, 0, 0);
					wprintw(err, "Not a directory!\007");
					refresh();
					wrefresh(err);
					break;
				}
lo2:				readin();
				wclear(dnm); wclear(fils);
				refresh();
				wrefresh(dnm);
				wrefresh(fils); 
				delwin(dnm); delwin(fils);
				fils = newwin(22, 20, 1, strlen(dname)+3);
				dnm = newwin(1, strlen(dname), 12, 0);
				wmove(dnm, 0, 0);
				wprintw(dnm, dname);
				refresh();
				wrefresh(dnm);
				level = 0;
				ypos = 1;
				dlev();
				break;
			case 's':
				wmove(err, 0, 0);
				wprintw(err, "Search in ");
				refresh();
				wrefresh(err);
				echo();
				nocrmode();
				gets(str);
				strcat(str, '/');	/* TMPFIX */
				noecho();
				crmode();
				if (stat(str, &fil) == -1) {
					perror("stat");
					cleanupwoc();
				}
				if (fil.st_uid == getuid()) {
					if (fil.st_mode & 0000400)
						goto ho;
				} else if (open(str, O_RDONLY) == -1) {
					wmove(err, 0, 0);
					wprintw(err, "Directory does not exist.\007");
					refresh();
					wrefresh(err);
					break;
				}
ho:				strcpy(dname, str);
				goto lo2;
				break;
			case '\022':
				redraw();
				break;
			case 'q':
				cleanup();
				break;
			case '\033':
				getchar();
				switch(getchar()) {
					case 'A':	/* UP */
						ypos--;
						if (ypos < 1)
							ypos = 1;
						break;
					case 'B':	/* DN */
						ypos++;
						if (ypos > 22)
							ypos = 22;
						break;
					default:
						break;
				}
				break;
			case '>':
				level++;
				dlev();
				break;
			case '<':
				level--;
				if (level < 0)
					level = 0;
				dlev();
				break;
			case '\012':
				i = ypos+mult;
				wmove(fst, 0, 0);
				wprintw(fst, "File: %s", l[i].name); wclrtoeol(fst);
				wmove(fst, 1, 0);
				wprintw(fst, "Inode: %d", l[i].f.st_ino); wclrtoeol(fst);
				wmove(fst, 2, 0);
				wprintw(fst, "Links: %d", l[i].f.st_nlink); wclrtoeol(fst);
				setpwent();
				pwd = getpwuid(l[i].f.st_uid);
				setgrent();
				grp = getgrgid(l[i].f.st_gid);
				(void) strcpy(buf,"----------");
				if(l[i].f.st_mode & 0000001) buf[9] = 'x';
				if(l[i].f.st_mode & 0000002) buf[8] = 'w';
				if(l[i].f.st_mode & 0000004) buf[7] = 'r';
				if(l[i].f.st_mode & 0000010) buf[6] = 'x';
				if(l[i].f.st_mode & 0000020) buf[5] = 'w';
				if(l[i].f.st_mode & 0000040) buf[4] = 'r';
				if(l[i].f.st_mode & 0000100) buf[3] = 'x';
				if(l[i].f.st_mode & 0000200) buf[2] = 'w';
				if(l[i].f.st_mode & 0000400) buf[1] = 'r';
				if(l[i].f.st_mode & 0001000) buf[9] = 't';
				if(l[i].f.st_mode & 0002000) buf[6] = 's';
				if(l[i].f.st_mode & 0004000) buf[4] = 's';
				switch(l[i].f.st_mode & S_IFMT) {
				case	S_IFDIR:
					buf[0] = 'd';
					break;
				case S_IFCHR:	
					buf[0] = 'c';
					break;
				case S_IFBLK:	
					buf[0] = 'b';
					break;
				case S_IFREG:	
					buf[0] = '-';
					break;
				case S_IFLNK:	
					buf[0] = 'l';
					break;
				case S_IFSOCK:	
					buf[0] = 's';
					break;
				default:
					buf[0] = '?';
				}
				wmove(fst, 3, 0);
				wprintw(fst, "Protection: (%04o) %s", l[i].f.st_mode & 07777, buf); 
				wmove(fst, 4, 0);
				wprintw(fst, "UID: %d (%s)", l[i].f.st_uid, pwd->pw_name); wclrtoeol(fst);
				wmove(fst, 5, 0);
				wprintw(fst, "GID: %d (%s)", l[i].f.st_gid, grp->gr_name); wclrtoeol(fst);
				wmove(fst, 6, 0);
				wprintw(fst, "Size: %d blocks (%d)", (l[i].f.st_size + 1023)/1024, l[i].f.st_size); wclrtoeol(fst);
				refresh();
				wrefresh(fst);
				break;
			default:
				break;
		}
		wclear(err);
		wrefresh(err);
	}
}

dlev()
{
	int	dnlen = strlen(dname) + 3;
	int	mult = (level * 22);
	for (i = 1 + mult; i < 23 + mult; i++)
		posyf(fils, i-mult, 0, l[i].name, NO);
	
}

