/*
 * $Header: /src3/ecn/access/RCS/glob.c,v 1.3 85/01/12 18:45:46 root Exp Locker: root $
 *
 * glob - filename expansion for access program
 *
 * This code is lifted almost directly from the Version 6 "glob"
 * program.  It is responsible for expanding the *, ?, and [...]
 * thingies in filenames.
 *
 * David A. Curry, April 1984
 *
 * $Log:	glob.c,v $
 * Revision 1.3  85/01/12  18:45:46  root
 * Modified so the group "other" hack is selectable with an ifdef.
 * 
 * Revision 1.2  84/07/19  09:08:02  root
 * fast version .. pre-structured
 * 
 * Revision 1.1  84/06/25  10:58:46  root
 * Initial revision
 * 
 */
#include "defs.h"

extern int ac;
extern int env[];
extern char *av[];
extern char *argptr;
extern char argbuf[];

glob(argstr)
char *argstr;
{
	char **oargv;
	char *concat();
	register char *s, *t;
	DIR *dirp, *opendir();
	char *index(), *homedir();
	struct direct *d, *readdir();

	/* 
	 * Save current place so we can sort
	 * things.
	 */
	oargv = &av[ac];
	
	s = t = argstr;

	while ((*t != '*') && (*t != '?') && (*t != '[')) {
		if (*t++ == NULL) {
			av[ac++] = concat(s, "");
			return;
		}
	}
	
	for (;;) {
		if (t == s) {
			dirp = opendir(".");
			s = "";
			break;
		}
		
		if (*--t == '/') {
			*t = NULL;
			dirp = opendir(s == t ? "/" : s);
			*t++ = 0200;
			break;
		}
	}
	
	if (dirp == NULL) {
		printf("glob: no directory\n");
		longjmp(env);
	}
	
	while ((d = readdir(dirp)) != NULL) {
		if (d->d_ino == 0)
			continue;
		
		if (match1(d->d_name, t))
			av[ac++] = concat(s, d->d_name);

		if (ac > MAXARGS)
			toomany();
	}
	
	closedir(dirp);
	sort(oargv);
}

match1(s, t)
char *s, *t;
{
	if ((*s == '.') && (*t != '.'))
		return(0);
	
	return(match3(s, t));
}

match3(s1, s2)
char *s1, *s2;
{
	register short x;
	short c, ch, ok, ch2;
	register char *s, *t;
	
	s = s1;
	t = s2;
	
	if (x = *s++)
		if ((x &= 0177) == 0)
			x = 0200;
	
	switch (c = *t++) {
	case '[':
		ok = 0;
		ch2 = 077777;
		
		while (ch = *t++) {
			if (ch == ']') {
				if (ok)
					return(match3(s, t));
				else
					return(0);
			}
			else if (ch == '-') {
				if ((ch2 <= x) && (x <= (c = *t++)))
					ok++;
			}
			else {
				if (x == (ch2 = ch))
					ok++;
			}
		}
		return(0);
	default:
		if (c != x)
			return(0);
	case '?':
		if (x)
			return(match3(s, t));
		return(0);
	case '*':
		return(match2(--s, t));
	case '\0':
		return(!x);
	}
}

match2(s, t)
char *s, *t;
{
	if (*t == 0)
		return(1);
	
	while (*s) {
		if (match3(s++, t))
			return(1);
	}
	
	return(0);
}

sort(args)
char **args;
{
	register char **p1, **p2, *s;

	p1 = args;

	while (p1 < &av[ac-1]) {
		p2 = p1;

		while (++p2 < &av[ac]) {
			if (compar(*p1, *p2) > 0) {
				s = *p1;
				*p1 = *p2;
				*p2 = s;
			}
		}

		p1++;
	}
}

compar(as1, as2)
char *as1, *as2;
{
	register char *s1, *s2;
	
	s1 = as1;
	s2 = as2;
	
	while (*s1++ == *s2) {
		if (*s2++ == NULL)
			return(0);
	}

	return(*--s1 - *s2);
}

char *concat(as1, as2)
char *as1, *as2;
{
	register int c;
	register char *s1, *s2;
	
	s1 = as1;
	s2 = argptr;

	while (c = *s1++) {
		if (s2 > &argbuf[MAXARGLEN])
			toolong();
		
		c &= 0177;
		
		if (c == NULL) {
			*s2++ = '/';
			break;
		}
		
		*s2++ = c;
	}
	
	s1 = as2;
	
	do {
		if (s2 > &argbuf[MAXARGLEN])
			toolong();

		*s2++ = c = *s1++;
	} while (c);
	
	s1 = argptr;
	argptr = s2;
	
	return(s1);
}

toolong()
{
	printf("glob: argument expansion list too long\n");
	longjmp(env);
}

toomany()
{
	printf("glob: too many arguments\n");
	longjmp(env);
}
