.nr PS 12
.ps 12
.nr VS 14
.vs 14
.DA October 1984
.EH 'Access'- % -'Access'
.OH 'Access'- % -'Access'
.EF 'Mahler/Curry'\*(DY'Purdue \s-1ECN\s+1'
.OF 'Purdue \s-1ECN\s+1'\*(DY'Mahler/Curry'
.RP
.TL
Access \-
A Program to Interpret Pathname Access
Permissions for the
.UX
Operating System
.AU
Stephen J. Mahler
David A. Curry
.AI
Engineering Computer Network
School of Electrical Engineering
Purdue University
West Lafayette, Indiana 47907
.AB
The program described in this paper,
.B access ,
was written to help users interpret the permissions set on their
files by showing in a concise format who may read,
write,
execute,
and remove a given file.
Rather than simply reporting the permissions on the file itself,
.B access
takes into account the permission bits set on the directories
leading to the file.
This results in a correct listing of exactly who may access the file,
whereas reporting the permissions on the file alone does not.
.AE
.NH 1
Introduction
.PP
When users are first introduced to
.UX ,
they are taught about files \-
how to edit them,
how to read them,
how to print them,
and how to delete them.
Unfortunately,
users are rarely given instruction on how to protect
or control access to their files.
At the Purdue Engineering Computer Network (\s-1ECN\s+1),
because many of our users are faculty and students
who use the computer for classwork,
file protection is an important aspect of
.UX
which we feel must be understood by even the most casual user.
Some class instructors even impose a penalty if a student leaves
his class-related files in an unprotected state.
.PP
Many users have problems in understanding the file protection facilites
under the
.UX
operating system.
The lack of understanding about the file protection mechanism
can be attributed to one or more of the following:
.IP 1.
There are three sets of permissions for each file.
These are the permissions for the file's owner,
other members of the owner's group,
and ``the rest of the world.''
Most users would have little trouble understanding that,
``I have one set of permissions,
and everyone else has another set.''
Unfortunately,
the concept of groups under
.UX
throws a monkey-wrench into the works.
Often new users are all placed into the same
default group,
and the above sentence now becomes,
``I have one set of permissions,
other people in my group have another set of permissions,
and the rest of the world has a third set of permissions.
But,
since almost everyone else is in my group,
then the group permissions are really more like the world permissions,
except that those people who aren't in my group still use the real
world permissions.''
It is no wonder that many users are confused.
.IP 2.
The program to change file permissions,
.B chmod (1),
was not written with the novice user in mind.
Modes are specified to
.B chmod
by giving it an octal representation of the permission bits to
be set on the file.
This may make sense to those who know how
.UX
stores file permissions,
however,
to the average user these
.ne 4
are just numbers with no inherent meaning\(dd.
.FS
\(dd
This may be due to the confusing nature (to the non-programmer)
of bit-fields and the logical operations
.B and
and
.B or .
.FE
The newer versions of
.B chmod
have included a symbolic notation
for specifying the modes to be set.
This is done by indicating which set (owner, group, world)
of permissions to change,
and which permissions (read, write, execute) to turn on and off.
For example,
the command
.B "chmod g-r"
.I filename
would be used to turn off group read permission on the
file
.I filename .
Although this notation is somewhat unwieldy at times,
it is an improvement over the octal notation.
.IP 3.
Users often do not realize that file access permissions are affected by the
permissions on the directories leading to the file.
For example,
if a user makes his file readable by everyone,
and yet his directory is searchable only by him,
he does not understand why his friend cannot copy the file.
.PP
To help new users protect their files,
the \s-1ECN\s+1 has created,
over the past several years,
four programs which attempt to eliminate
the sources of confusion described above.
This document is primarily intended to describe the newest program,
.B access .
However,
because
.B access
can use the other three programs,
they will be described in brief.
.NH 1
\s-1LOCK\s+1 and \s-1UNLOCK\s+1
.PP
Several years ago,
the \s-1ECN\s+1 created two programs for changing file permissions.
These programs are called
.B lock
and
.B unlock .
The
.B lock
program removes read, write, and execute permission for the group and
world on each file named in its arguments.
The
.B unlock
program restores read and execute permission for the group and world
on each file named in its arguments.
Both programs,
if no arguments are given to them,
will change the permissions on the user's current working directory.
.PP
Actually,
.B lock
and
.B unlock
were implemented as a single shell script,
shown below:
.DS
.nf
.ta 5m 10m 15m 20m 25m 30m 35m 40m 45m 50m 55m 60m
PATH=/bin
mode=go-rwx

case $0 in
	unlock|*/unlock)	mode=go+rx
esac

for name in ${*\-.}
do
	if test ! \e( -f $name -o -d $name \e)
	then
		echo Making directory $name
		mkdir $name
	fi
	/bin/chmod $mode $name
done
.DE
.NH 1
The \s-1INFO\s+1 Program
.PP
The
.B info
program prints information about a file.
Basically,
it is a combination of the
.B file (1)
program,
and the
.B stat (2)
system call.
For each file named in its arguments,
.B info
will print the name of the file,
its type (directory, normal file, character special file, etc.),
its size,
a guess at the contents of the file,
the owner and group of the file,
and the creation,
last modification,
and last access times for the file.
If the
.B \-v
(verbose)
flag is given,
the number of links to the file,
its inode and device numbers are also printed.
.PP
An important feature of
.B info
with respect to file permissions is that it ``decodes'' the
permissions set on the file.
These permissions are printed in three formats.
First,
the octal representation of the permission bits is printed.
Second,
the ``rwx'' notation as used by
.B ls (1)
is printed,
and third,
a list of which permissions the owner,
group,
and world have on that file (\s-1N\s+1.\s-1B.\s+1: these are permissions
on the file only,
the directories leading to the file are not considered).
This is demonstrated in the example below:
.DS
.ta 5m 20m
$ info /etc/passwd
	File Name	- /etc/passwd
	File Type	- normal file
	File Size	- 115525 bytes, 113 Kbytes
	File Contents	- ASCII text
	Uid of Owner	- root (0)
	Gid of Owner	- root (0)
	File Mode	- rw-r--r-- (644)
.ta 14m
	User root: readable, writable
.ta 13m
	Group root: readable
.if t .ta 12m
.if n .ta 10m
	Everyone else: readable
.ta 5m 15m
	Links to file	- 1
	Inode Number	- 2130
	Inode's Device	- 4
	Creation Time	- Tue Sep 25 09:12:08 1984
	Last Modified	- Tue Sep 25 09:12:07 1984
	Last Accessed	- Tue Sep 25 09:55:20 1984
$
.DE
.NH 1
The \s-1ACCESS\s+1 Program
.PP
The
.B access
program actually determines who may read,
write,
execute,
and remove a given file.
It is the newest of the four programs,
and we believe that it is unique in its approach to interpreting
.UX
file permissions.
.B Access
operates in one of two modes.
It can accept command-line arguments,
or,
if no arguments are given,
it enters an interactive mode.
When arguments are given,
.B access
will print out the access permissions for each file named.
.PP
Access determines file access permissions
using the following algorithm (see the
next section for a more detailed description):
.DS
.ta 5m 10m 15m 20m 25m 30m 35m 40m 45m 50m 55m 60m
file = \fIfull path to file\fP
path = ``/''

\fBrepeat\fP
	\fIdetermine access permissions on\fP path

	\fBfor\fP i = 1 \fBto\fP \s-1MAXUSERS\s+1 \fBdo\fP
		\fIdetermine whether user\d\s-2i\s+2\u may read\fP path
		\fIdetermine whether user\d\s-2i\s+2\u may write\fP path
		\fIdetermine whether user\d\s-2i\s+2\u may execute\fP path
	
		\fIcombine this information with that determined\fP
		\fIfor the previous value of\fP path
	\fBend\fP

	path = path + \fBnextcomponent\fP(file)
\fBuntil\fP path == file
.DE
.LP
When the algorithm has finished,
each user's access permissions for the file in question will be known.
This information is then processed to determine the most
concise way to print it,
and the result is then printed on the standard output.
For example,
the command
.B "access /etc/passwd"
produces the output
.DS
.ta 10m
/etc/passwd (file):
	Readable by: everybody
	Writable by: root
	Executable by: nobody
	Removable by: root and members of group root
.DE
.LP
If the current directory is
.I /e/davy/system/miscellaneous ,
the command
.B "access foo"
might produce the output
.DS
.ta 10m
/e/davy/system/miscellaneous/foo (file):
	Readable by: members of group nightowl
	Writable by: davy
	Executable by: nobody
	Removable by: davy
.DE
.LP
Note that the entire path to the file is printed.
.PP
If
.B access
is invoked with no arguments,
interactive mode is initiated.
In this mode,
.B access
behaves as a special shell,
and permits the user to execute various commands to examine and change
the permissions on his files.
The following section describes the commands available in the interactive
mode.
.NH 2
\s-1ACCESS\s+1 Interactive User's Manual
.PP
When
.B access
is first invoked,
it determines the current working directory.
Once this has been done,
the prompt
.I Command :
is printed.
The commands available are:
.IP "\fBaccess\fP \fIfile\fP [\fIfile file .....\fP]"
The
.B access
command prints out a list of who may read,
write,
execute,
and remove each file or directory listed on the command line.
This list may be a single user's name,
the name of a group,
or a list of names.
Although
.B access
is fairly smart about figuring out the most concise way to list the people
who may do something to a file,
occasionally it can't.
If this happens,
a line such as ``there are 592 names in this list'' will be printed,
and you will be asked if you really want to see the list.
If you do want to see the list,
type `y' (for `yes'),
otherwise,
type `n' (for `no').
.IP "\fBcat\fP [\fIargs\fP] \fIfile\fP [\fIfile file .....\fP]"
Execute the
.B cat (1)
program on the named files.
This is used when you want to see what a file contains.
Some of the arguments
.B cat
accepts are
.B \-n
to number the lines,
and
.B \-v
to print ``invisible'' characters.
.IP "\fBcd\fP \fIdirectory-name\fP"
Change into the directory named
.I directory-name.
This command is just like the shell command of the same name.
.IP "\fBchmod\fP \fImode file\fP [\fIfile file .....\fP]
Execute the
.B chmod (1)
command on the named files.
.B Chmod
is used to change the permissions on a file.
Modes are described in the manual for
.B chmod
and also in the help file for
.B access
(see the \fBhelp\fP command).
.IP "\fBexit\fP"
Exit the
.B access
program.
.IP "\fBquit\fP"
The same as
.B exit .
You may also type Control-\s-1D\s+1 to exit.
.IP "\fBhelp\fP"
Display a help file listing all the commands available and their uses.
This file is printed with the
.B more (1)
command.
Typing a question mark (`?') also shows this file.
.IP "\fBinfo\fP [\fIargs\fP] \fIfile\fP [\fIfile file .....\fP]"
Run the
.B info (1)
command on the named files.
.B Info
prints out various pieces of information about a file or directory,
such as its mode,
owner,
size,
contents,
creation time,
etc.
Some of the arguments to
.B info
include
.B \-v
to print even more information,
such as number of links,
inode numbers,
etc.,
and
.B \-f
to skip trying to guess what's in the file.
.IP "\fBlock\fP [\fIfile file file .....\fP]"
Lock the named files.
If no files are named,
then the current directory is locked.
.B Lock
is a variant of the
.B chmod
command;
it simply makes everything mode 0700 (readable, writable, and executable
by the owner only).
.IP "\fBls\fP [\fIargs\fP] [\fIfile file file .....\fP]"
Execute the
.B ls (1)
command on the named files.
If no files are named,
the files in the current directory are listed.
Some of the arguments to
.B ls
include
.B \-l
to get a long listing,
.B \-s
to show the size in kilobytes of each file,
and
.B \-a
to show files whose names begin with `.'.
.IP "\fBmore\fP [\fIargs\fP] \fIfile\fP [\fIfile file .....\fP]"
Execute the
.B more (1)
command on the named files.
.B More
is similar to
.B cat,
except that it stops after every page of the file and waits for the
user to press the space bar before going to the next page.
.IP "\fBpwd\fP"
Print the pathname of the current directory.
.IP "\fBsh\fP"
Execute a shell.
The shell executed is normally taken from the environment variable
.B \s-1SHELL\s+1 ,
if this is not set,
.I /bin/sh
is used.
To return to
.B access,
type Control-\s-1D\s+1 (press the \s-1CTRL\s+1 key and the \s-1D\s+1
key at the same time).
.IP "\fBcsh\fP"
The same as the
.B sh
command.
.IP "\fBunlock\fP [\fIfile file file .....\fP]"
Unlock the named files.
If no files were named,
unlock the current directory.
This is the inverse of the
.B lock
command;
it makes the named files mode 0755 (readable, writable, and executable by
the owner, readable and executable by everyone else).
.PP
In interactive mode,
.B access
understands the
.I metacharacters
used in the shell.
That is,
when naming files,
the characters `*',
`?',
and `[]'
have special meanings.
These are described in the manual for the shell,
either
.B sh (1)
or
.B csh (1).
.B Access
also understands the `~' character,
which represents the home directory.
For example,
a `~' alone represents your home directory,
but ``~davy'' represents the home directory for user ``davy.''
.NH 1
How \s-1ACCESS\s+1 Works
.PP
.B Access
works by simulating (after a fashion) the
.B access (2)
system call for each user on the system.
For each user,
a structure is maintained containing the user's user id,
login name,
and a list of the groups for which he is a member.
For each group,
a structure is maintained containing the group's group id,
its group name,
and the number of users who are members of that group.
The support program
.B mkaccessdb
is run nightly by
.B cron (8)
and is responsible for making the lists of users and groups and determining
which groups each user belongs to.
This information is then saved in two files which are loaded into memory
each time the
.B access
program is executed.
.PP
The first thing
.B access
does to determine who may access a file is to figure out the full
pathname to that file.
This is done by obtaining the name of the current directory,
and concatenating the name of the file to it.
The concatenation routine is somewhat intelligent,
and resolves things like ``../'' and ``./'' automatically.
If a file's name begins with `/',
the full pathname is already known,
and the above procedure is not performed.
.PP
Now that the full path to the file is known,
.B access
begins ``walking'' the path and determining the protection mode of
each component in the path using the
.B stat (2)
system call.
At the outset,
each user is ``granted'' permission to read,
write,
and execute any file.
As the path is traversed,
the permissions for each user are modified according to the permission bits
set for the current path component.
These modifications are made following the same rules used by the operating
system to determine access permissions.
By logically
.I and ing
the file's permission bits with those of the user,
the new permission bits for the user can be determined.
Note that this implies that while a user may
.I lose
permission to do something to a file,
he can never
.I gain
permission to do something.
The problem of which set (owner, group, world) of permission bits
to use when determining a specific user's permissions is resolved
by the following rules:
.IP 1.
If the user whose permissions are currently being determined
owns the file (or directory) being evaluated,
his access permission is determined by the owner permissions on
the file (directory).
If he does not own the file,
the group and world permissions will be checked.
.IP 2.
If the user is a member of the group which owns the file,
and he does not own the file,
his access permission is determined by the group permissions on
the file.
If he is not a member of the group,
the world permissions will be checked.
.IP 3.
If the user does not own the file,
and he is not a member of the group which owns the file,
his access permissions will be determined by the world
permissions on the file.
.LP
Note that under no circumstances will a user's access permission be determined
by more than one set of permission bits on the file.
In this way,
he cannot regain access permission which has been denied by a previous set
of permission bits.
.PP
Finally,
after determining the access permissions for every user,
.B access
attempts to figure out a way to group together those users who have a
certain access permission.
For example,
if all the users who have write permission on the file are members
of the same group,
then
.B access
can print ``members of group x'' instead of listing the users
individually.
Of course,
if one of the users in the group does not have write permission on
the file (e.g., if the owner permissions are read and execute and
the group permissions are read, write, and execute
and the owner is a member of the group),
.B access
would modify the message slightly to read ``members of group x except y.''
Many other combinations are possible,
and
.B access
is nearly always capable of finding one that fits.
In the few cases in which it cannot decide on a grouping
(for example,
when there are many subdirectories in the path to the
file, each one owned by a different user and group,
and file permissions which alternate between owner-only
and ``everybody''),
.B access
will offer to print the entire list of names.
The user may decide whether he wishes to see this list.
.PP
The amount of processor time used by
.B access
can be divided into two parts:
the time taken to read in the user and group files (a once per invocation
occurrence),
and the time taken to actually determine the access permissions for
a file.
For an ``average'' password file containing 107 users,
.B access
uses less than 0.3 seconds of processor (sys + user) time.
For an extremely large password file containing 1,842 users,
0.2 seconds of user time and 1.1 seconds of system time are used.
These times were recorded on a \s-1VAX\s+1-11/780 under 4.2\s-1BSD\s+1.
This initial overhead (particularly with the large password file)
prompted the creation of the interactive form of the command,
enabling users to save time when checking several files
by only reading the user and group files once.
.PP
After the user and group files have been read in,
.B access
runs very rapidly.
To print out the access permissions for five files,
each file five levels deep (i.e.,
.I /a/b/c/d/e ),
.B access
requires 4.8 seconds of user time and 0.4 seconds of system time (in
addition to the times used to read in the files) when running with
the large password file;
approximately 0.2 seconds of user and system time combined are needed
when using the short password file.
The times to print out the access permissions for the root directory (``/'')
are 0.4 seconds of user time and
0.1 seconds of system time for the large password file;
less than 0.1 seconds of combined user and system time are needed when
using the short password file.
.NH 1
Special Cases
.PP
.B Access
treats two conditions as special cases.
First,
.B access
does not acknowledge that user
.I root
has the capability to read,
write,
and execute
.I all
files,
regardless of their owners or permissions.
This treatment was decided upon in order to prevent users from becoming
confused by some unknown account (root) who could always read,
write,
and execute their files.
.PP
Secondly,
if
.B access
encounters a file owned by a user who is not in the password file,
it assumes that the user does not exist (since it is impossible to
log in under that user id).
Thus,
if a mode 0700 (read, write, and execute for owner only)
file is owned by a non-existent user,
.B access
will state that nobody can read,
write,
or execute the file.
.NH 1
Conclusion
.PP
The
.B access
program has been well-received at the \s-1ECN\s+1,
and is presently being taught to new students who are enrolled
in the beginning computer course for the School of Electrical Engineering.
By automating the process of determining who may access a file,
the confusion for the user has been removed.
Although this is arguably wrong,
since the user will probably never learn how the permissions actually
work,
it seems to be the most desirable solution.
This is primarily because most of our student users use the machine for
coursework only,
and are not interested in how things work,
only in getting their work done.
.FS
This document and the software it describes are hereby placed
in the public domain and may be used by anyone for any purpose
provided that they are not used or sold for profit and that
this notice and the names of the orignal authors appear with
all copies.
.FE
