static char *RCSid = "$Header: /src3/ecn/access/RCS/main.c,v 1.3 84/08/07 13:30:45 root Exp $";

/*
 * main.c - main() and handler() routines for the access program.
 *	    All global variables are declared here.
 *
 * David A. Curry, April 1984
 *
 * $Log:	main.c,v $
 * Revision 1.3  84/08/07  13:30:45  root
 * allow file names on the command line
 * 
 * Revision 1.2  84/07/19  09:08:08  root
 * fast version .. pre-structured
 * 
 * Revision 1.1  84/06/25  10:58:47  root
 * Initial revision
 * 
 */
#include "defs.h"

struct grp *ghead, *gtail;		/* ptrs to list's head and tail	*/
struct user *uhead, *utail;		/* ptrs to list's head and tail */

int nusers;				/* number of entries in list	*/
int kidpid = 0;				/* pid of child process		*/

char reset;				/* 1 if should reset on int.	*/
jmp_buf env;				/* where to reset to		*/
char *pname;				/* global argv[0]		*/
char cur_dir[MAXPATHLEN];		/* current working directory	*/

main(argc, argv)
int argc;
char **argv;
{
	char *getwd();
	char *rindex();
	extern handler();
	struct rlimit rlim;
	extern char _sobuf[];
	
	setbuf(stdout, _sobuf);

	reset = 0;
	signal(SIGINT, handler);
	signal(SIGQUIT, handler);

	/*
	 * Only print this stuff if we
	 * are interactive, i.e., no
	 * arguments given.
	 */
	if (argc < 2) {
		printf("Initializing.....please wait.....");
		fflush(stdout);
	}
	
	if ((pname = rindex(*argv, '/')) == NULL)
		pname = *argv;
	else
		pname++;
	
	/*
	 * Jack up our limits.
	 */
	rlim.rlim_cur = rlim.rlim_max = RLIM_INFINITY;

	setrlimit(RLIMIT_CPU, &rlim);
	setrlimit(RLIMIT_RSS, &rlim);
	setrlimit(RLIMIT_DATA, &rlim);
	setrlimit(RLIMIT_STACK, &rlim);
	
	/*
	 * Get the current directory.
	 */
	if (getwd(cur_dir) == NULL) {
		fprintf(stderr, "%s: getwd failed - %s\n", pname, cur_dir);
		exit(1);
	}
		
	/*
	 * Load in the password and group files.
	 */
	loaduids();
	loadgids();

#ifdef DEBUG /*------------------------------------------------------------*/
	printf("Done processing uids and gids\n");
#endif /*------------------------------------------------------------------*/

#ifdef LISTDEBUG /*--------------------------------------------------------*/
	printlist();
#endif /*------------------------------------------------------------------*/

	/*
	 * No return.  If we are interactive, we
	 * go to our command interpreter, otherwise,
	 * we just call access with our arguments.
	 */
	if (argc < 2)
		command();
	else
		access(argc, argv);
	
	exit(0);
}

/*
 * handler - handles interrupts.
 */
handler(sig)
int sig;
{
	signal(sig, SIG_IGN);
	signal(sig, handler);
	
	/*
	 * If there's a child process, blow
	 * it away.
	 */
	if (kidpid)
		kill(kidpid, sig);

	printf("\nINTERRUPT!\n");
	
	/*
	 * Reset or exit.
	 */
	if (reset)
		longjmp(env);
	else
		exit(0);
}
