/*
 * $Header: /src3/ecn/access/RCS/commands.c,v 1.2 84/07/19 09:07:52 root Exp $
 *
 * commands.c - command routines for access program
 *
 * David A. Curry, April 1984
 *
 * $Log:	commands.c,v $
 * Revision 1.2  84/07/19  09:07:52  root
 * fast version .. pre-structured
 * 
 * Revision 1.1  84/06/25  10:58:44  root
 * Initial revision
 * 
 */
#include "defs.h"

extern int reset;
extern int env[];
extern int kidpid;
extern char cur_dir[];

int ac;					/* arg count			*/
char *argptr;				/* pointer to end of argbuf	*/
char *av[MAXARGS];			/* argument pointers		*/
char argbuf[MAXARGLEN];			/* arguments			*/

/*
 * command - top level interface to the user.
 */
command()
{
	char *index();
	char buf[1024];
	register int i;
	char *homedir();
	register char *s, *t;
	
	printf("\n\nWelcome to the file access program.\n");
	printf("If you need instructions, type \"help\".\n");
	printf("When you're ready to leave, type \"quit\".\n\n");
	
	printf("You are in '%s'\n\n", cur_dir);
	
	/*
	 * We want to come back here on interrupt.
	 */
	reset = 1;
	
	for (;;) {
		/*
		 * Come back to here on longjmp.
		 */
		setjmp(env);

		/*
		 * Zero the string.
		 */
		for (i=0; i < 1024; i++)
			buf[i] = NULL;

		/*
		 * Prompt and read in a line.
		 */
		printf("Command: ");
		fflush(stdout);
		
		if (gets(buf) == NULL)
			quit();
		
		/*
		 * Don't do anything if they typed a
		 * blank line.
		 */
		if (*buf == NULL)
			continue;

		/*
		 * Skip whitespace at beginning of line.
		 */
		ac = 0;
		s = buf;
		while ((*s != NULL) && ((*s == ' ') || (*s == '\t')))
			s++;
		
		/*
		 * Save first argument.
		 */
		av[ac++] = s;

		while ((*s != NULL) && (*s != ' ') && (*s != '\t'))
			s++;

		*s++ = NULL;
		
		/*
		 * Now process all the other arguments.
		 */
		argptr = argbuf;
		
		while ((*s != NULL) && (ac < MAXARGS)) {
			/*
			 * Skip leading whitespace.
			 */
			while ((*s == ' ') || (*s == '\t'))
				s++;
			
			t = s;
			
			/*
			 * Skip to end of word.
			 */
			while ((*s != ' ') && (*s != '\t') && (*s != NULL))
				s++;
			
			*s++ = NULL;

			/*
			 * Glob it.
			 */
			if (*t == '~')
				t = homedir(t);

			glob(t);
		}
		
		/*
		 * Null terminate the arg list.
		 */
		av[ac] = 0;
		
#ifdef DEBUG /*------------------------------------------------------------*/
		for (i=0; i < ac; i++)
			printf("argv[%d] = '%s'\n", i, av[i]);
#endif /*------------------------------------------------------------------*/

		/*
		 * Match the command name.
		 */
		if (!strcmp(av[0], "access"))
			access(ac, av);
		else if (!strcmp(av[0], "cat"))
			cat(ac, av);
		else if (!strcmp(av[0], "cd"))
			cd(ac, av);
		else if (!strcmp(av[0], "chmod"))
			changemode(ac, av);
		else if (!strcmp(av[0], "help") || !strcmp(av[0], "?"))
			help(ac, av);
		else if (!strcmp(av[0], "info"))
			info(ac, av);
		else if (!strcmp(av[0], "lock"))
			lock(ac, av);
		else if (!strcmp(av[0], "ls"))
			ls(ac, av);
		else if (!strcmp(av[0], "more"))
			more(ac, av);
		else if (!strcmp(av[0], "pwd"))
			pwd(ac, av);
		else if (!strcmp(av[0], "quit") || !strcmp(av[0], "exit"))
			quit(ac, av);
		else if (!strcmp(av[0], "sh") || !strcmp(av[0], "csh"))
			shell(ac, av);
		else if (!strcmp(av[0], "unlock"))
			unlock(ac, av);
		else
			printf("Unknown command: '%s'\n", av[0]);
	}
}

/*
 * access - print out who can access a file.
 */
access(argc, argv)
int argc;
char **argv;
{
	if (argc < 2) {
		printf("Usage: access file(s) .....\n");
		return;
	}
	
	while (--argc)
		process(*++argv);
}

/*
 * cat - run cat on file
 */
cat(argc, argv)
int argc;
char **argv;
{
	argv[0] = CAT;
	execute(argc, argv);
}

/*
 * cd - change directory
 */
cd(argc, argv)
int argc;
char **argv;
{
	if (argc != 2) {
		printf("Usage: cd directory-name .....\n");
		return;
	}

	if (chdir(argv[1]) < 0) {
		printf("cd: cannot change into '%s'\n", argv[1]);
		return;
	}
	
	/*
	 * Get new directory path.
	 */
	if (getwd(cur_dir) == NULL) {
		printf("cd: getwd failed -- '%s'\n", cur_dir);
		return;
	}
	
	printf("Now in directory '%s'\n", cur_dir);
}

/*
 * changemode - chmod files
 */
changemode(argc, argv)
int argc; 
char **argv;
{
	if (argc < 3) {
		printf("Usage: chmod mode filename(s) .....\n");
		return;
	}
	
	argv[0] = CHMOD;
	execute(argc, argv);
}

/*
 * help - print help file
 */
help(argc, argv)
int argc;
char **argv;
{
	argv[0] = MORE;
	argv[1] = HELPFILE;
	argv[2] = NULL;
	argc = 2;
	
	execute(argc, argv);
}

/*
 * info - run the info command
 */
info(argc, argv)
int argc;
char **argv;
{
	argv[0] = INFO;
	execute(argc, argv);
}

/*
 * lock - lock files by chmod'ing them all to 0700.
 */
lock(argc, argv)
int argc;
char **argv;
{
	int i;
	
	if (argc == 1) {
		argv[argc++] = "0700";
		argv[argc++] = ".";
	}
	else {
		for (i=argc++; i > 1; i--)
			argv[i] = argv[i-1];
		argv[1] = "0700";
	}
	
	argv[0] = CHMOD;
	execute(argc, argv);
}

/*
 * ls - run ls.
 */
ls(argc, argv)
int argc;
char **argv;
{
	argv[0] = LS;
	execute(argc, argv);
}

/*
 * more - run more on file
 */
more(argc, argv)
int argc;
char **argv;
{
	argv[0] = MORE;
	execute(argc, argv);
}

/*
 * pwd - print working directory
 */
pwd(argc, argv)
int argc;
char **argv;
{
	printf("You are in '%s'\n", cur_dir);
}

/*
 * quit - go bye-bye.
 */
quit(argc, argv)
int argc;
char **argv;
{
	printf("\n");
	exit(0);
}

/*
 * unlock - unlock files by chmod'ing them to 0755.
 */
unlock(argc, argv)
int argc;
char **argv;
{
	int i;
	
	if (argc == 1) {
		argv[argc++] = "0755";
		argv[argc++] = ".";
	}
	else {
		for (i=argc++; i > 1; i--)
			argv[i] = argv[i-1];
		argv[1] = "0755";
	}
	
	argv[0] = CHMOD;
	execute(argc, argv);
}

/*
 * shell - fork a shell.
 */
shell(argc, argv)
int argc;
char **argv;
{
	char *getenv();
	
	if ((argv[0] = getenv("SHELL")) == NULL)
		argv[0] = SH;
	
	execute(argc, argv);
	printf("\n");
}

/*
 * execute - fork and execute a command
 */
execute(argc, argv)
int argc;
char **argv;
{
	while ((kidpid = fork()) < 0) {
		printf("execute: can't fork -- retrying .....\n");
		sleep(5);
	}
	
	if (kidpid == 0) {
		/*
		 * Restore signals to default actions.
		 */
		signal(SIGINT, SIG_DFL);
		signal(SIGQUIT, SIG_DFL);
		
		execv(argv[0], argv);
		printf("execute: cannot execute '%s'\n", argv[0]);
		exit(0);
	}
	while (wait((int *) 0) != kidpid);
	
	kidpid = 0;
}

/*
 * homedir - does "~" expansion to home directories.
 */
char *homedir(str)
char *str;
{
	int count;
	char name[9];
	char *malloc();
	register char *s, *t;
	register struct passwd *p;
	struct passwd *getpwuid(), *getpwnam();

	s = str;
	t = name;
	count = 0;
	
	/*
	 * Copy the login name.
	 */
	s++;
	while (isalpha(*s) || isdigit(*s) || (*s == '-') || (*s == '_')) {
		*t++ = *s++;
		
		if (++count > 8)
			return(str);
	}

	*t = NULL;
	
	/*
	 * Get the directory.  If *name is NULL,
	 * they gave us just "~".
	 */
	if (*name == NULL) {
		if ((p = getpwuid(getuid())) == PNULL)
			return(str);
	}
	else {
		if ((p = getpwnam(name)) == PNULL)
			return(str);
	}
	
	if ((t = malloc(strlen(s) + strlen(p->pw_dir) + 1)) == NULL)
		return(str);

	strcpy(t, p->pw_dir);
	
	if (*s)
		strcat(t, s);
	
	return(t);
}
