/*
 * $Header: /src3/ecn/access/RCS/defs.h,v 1.3 85/02/01 13:09:20 root Exp $
 *
 * defs.h - constants and structure declarations for the access program
 *
 * David A. Curry, April 1984
 *
 * $Log:	defs.h,v $
 * Revision 1.3  85/02/01  13:09:20  root
 * Rearranged some defines, etc. for easier compilation.
 * 
 * Revision 1.3  85/02/01  13:03:43  root
 * 
 * 
 * Revision 1.2  84/07/19  09:07:58  root
 * fast version .. pre-structured
 * 
 * Revision 1.1  84/06/25  10:58:45  root
 * Initial revision
 * 
 */
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <signal.h>
#include <setjmp.h>
#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <grp.h>

/*
 * These constants are site dependent.  
 *
 * LS, INFO, MORE, and CHMOD are the pathnames of the programs of the
 * same name.  SH should be the path to the shell your site normally uses.  
 * The "info" program is a program which basically prints out the stat(2)
 * structure of a given file.  HELPFILE is the path to the access.help
 * file, displayed by the "help" command.
 *
 * MAXARGS is the maximum number of arguments to be passed to a command.
 * It should be big enough to permit wildcard globbing.  MAXARGLEN is
 * the maximum combined length of all the arguments to a command.  If
 * you plan to use a password file sorted by user id (it increases the
 * speed of initialization greatly, for large password files), define
 * PASSWDBYUID to the path of the new password file.
 *
 * THRESHOLD is the maximum number of names printed by the printall()
 * routine without asking the user if he really wants to see the list.
 * This is for when permissions come out really bizzare and access has
 * no alternative but to print practically the entire password file.
 */
#define SH		"/bin/sh"
#define LS		"/bin/ls"
#define CAT		"/bin/cat"
#define INFO		"/usr/ecn/info"
#define MORE		"/usr/ucb/more"
#define CHMOD		"/bin/chmod"
#define MAXARGS		1024
#define HELPFILE	"/usr/lib/access/access.help"
#define USERFILE	"/usr/lib/access/userfile"
#define GROUPFILE	"/usr/lib/access/groupfile"
#define THRESHOLD	25
#define MAXARGLEN	10240
#define PASSWDBYUID	"/usr/lib/access/passwd.by.uids"

/*
 * These constants shouldn't need to be changed.
 */
#define ADD		0
#define SET		1
#define GNULL		(struct group *) NULL
#define PNULL		(struct passwd *) NULL
#define USIZE		sizeof(struct user)
#define GSIZE		sizeof(struct grp)
#define NSIZE		9
#define EXECP		01		/* execute permission		*/
#define READP		04		/* read permission		*/
#define GRNULL		(struct grp *) NULL
#define USNULL		(struct user *) NULL
#define WRITEP		02		/* write permission		*/
#define ROOTDIR		"/"		/* root directory		*/
#define isdirectory(x)	((x & S_IFMT) == S_IFDIR)

/*
 * These constants are defined on 4.2BSD, but sometimes
 * not in other places.  We give them some easy values
 * here.
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN	1024
#endif
#ifndef NOGROUP
#define NOGROUP		-1
#endif
#ifndef NGROUPS
#define NGROUPS		1
#endif

struct user {
	int uid;			/* user id			*/
	char perm;			/* current permissions enabled	*/
	char operm;			/* pervious permissions	enabled	*/
	char uname[NSIZE];		/* login name			*/
	int groups[NGROUPS];		/* groups he's a member of	*/
};

struct grp {
	int gid;			/* group id			*/
	int nmembers;			/* number of people in group	*/
	char gname[NSIZE];		/* group name			*/
};

struct Grp {
	struct grp g;
	struct Grp *next;
};

struct User {
	struct user u;
	struct User *next;
};

