/*
 * $Header: xsfldesc.c,v 1.6 87/05/11 15:50:16 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	xsfldesc.c,v $
 * Revision 1.6  87/05/11  15:50:16  brandon
 * removed debugging
 * 
 * Revision 1.5  87/05/11  15:47:13  brandon
 * another check added
 * 
 * Revision 1.4  87/05/11  15:42:25  brandon
 * wrong debug sring
 * 
 * Revision 1.3  87/05/11  15:38:54  brandon
 * bugchk
 * 
 * Revision 1.2  87/04/29  11:31:28  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  xsfldesc() -- Return complete screen field description
 *
 * DIFFERENCE FROM UNIFY:  This function is not provided in the UNIFY screen
 * interface.  Its purpose is to allow screen fields to be examined or set
 * from a program.  In particular, a program may load extended attributes
 * (uppercase shifting only at present) for screen fields, which will then be
 * used automatically by inbuf() and input().
 *
 * This function returns a pointer to the internal screen field structure,
 * which is delared in xsfdesc.h.
 */

struct q *xsfldesc(sfld) {
	if (sfld < 0 || sfld >= __nsf)
		return (struct q *) 0;
	return &__scf[sfld];
}
