/*
 * $Header: usc.h,v 1.1 87/05/28 14:04:04 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	usc.h,v $
 * Revision 1.1  87/05/28  14:04:04  brandon
 * Initial revision
 * 
 */

#ifdef lint
# define NOMACROS
#endif
#include <curses.h>
#include <dbtypes.h>
#include <fdesc.h>
#include <ctype.h>
#ifdef UNIFY32
#include <domains.h>
#endif

#ifdef TERMCAP

/* Old curses.  We have to emulate some of the new features. */

#define beep()		write(1, "\7", 1)
#define flash()		beep()
#define cbreak()	crmode()
#define nocbreak()	nocrmode()

#endif
#if defined(lint) || defined(TERMCAP)

#define A_STANDOUT	0x80
#define A_REVERSE	0x80
#define A_UNDERLINE	0x00
#define A_ALTCHARSET	0x00
#define A_BLINK		0x00
#define A_DIM		0x00
#define A_BOLD		0x00
#define A_INVIS		0x00
#define A_PROTECT	0x00
#define A_ATTRIBUTES	A_STANDOUT
#define A_CHARTEXT	0x7f

#endif

struct q {
	char q_name[8];
	char q_dbfld[44];
	short q_fld;
	short q_type;
	short q_len;
	short q_fx;
	short q_fy;
	char q_prmp[40];
	short q_px;
	short q_py;
};

extern struct q *__scf;
extern int __nsf;

/*
 * If a screen field's type has _UCF OR'ed in with it, it will be upshifted
 * during calls to input() and inbuf().
 */

extern int _sh_up;		/* set this flag nonzero for upshifting */
#define _UCF		0x80	/* the flag value for upshifted sfields */

/*
 * Date and brackets, since the U.S. (as usual) is different from the rest
 * of the world...
 */

/* brackets */

#define MASK_BRACKETS	0x80
#define INTERNATIONAL	0x00
#define UNITED_STATES	0x80

/* dates */

#define MASK_DATES	0x03
#define YMD		0x00
#define DMY		0x01
#define MDY		0x02

extern int _ldbrt;

/* used internally for date array addressing */

#define MONTH		0
#define DAY		1
#define YEAR		2	/* ...guess what country Unify Corp. is in! */

#if defined(lint) && !defined(TERMCAP)

/*
 * Curses defines <struct screen> under USG, but doesn't declare it.  This
 * makes lint upset.
 */

struct screen {
	char dummy;
};

#endif

/* return codes for input routines */

#define FWD_OK		0	/* RETURN with data */
#define BKSP		-1	/* inc() backspace */
#define BACK		-2	/* TAB */
#define FWD		-3	/* RETURN */
#define LOOK		-4	/* ^V `view mode' (aka ACCELL `zoom') */
#define GO		-5	/* ESC */
#define GO_OK		-6	/* ESC with data */
#define BACK_OK		-7	/* TAB with data */
#define CFWD		-8	/* inc() forward */
#define CBACK		-9	/* inc() backward */

#define XRC_GO		1	/* allow GO, GO_OK return codes */
#define XRC_XOK		2	/* allow GO_OK, BACK_OK return codes */
#define XRC_LOOK	4	/* allow LOOK return code (no LOOK_OK) */
#define XRC_CFB		8	/* for incs(): include CFWD, CBACK */
#define XRC_BKSP	16	/* for incs(): include BKSP */
#define XRC_CHAR	32	/* for incs(): return non-ctl chars */
#define XRC_FWDGO	64	/* for incs(): RETURN == GO instead of FWD */
#define XRC_NOFLSH	128	/* for incs(): suppress refresh() call */

extern int __ext_rcodes;

/* the eternal happiness of strict(-ish) type checking... */

extern char *getpass();
extern char *malloc();
extern long time();
extern char *ctime();
extern void exit();
extern void _exit();
extern void free();
extern char *getenv();
extern char *strcpy();
extern char *strcat();
extern char *strchr();
extern WINDOW *newwin();
extern int sprintf();

extern short kday();
extern void kdate();
extern void cfill();
#ifdef UNIFY32
extern char *getdoms();
extern void dspdt();
#endif

extern void setraw();
extern void prtmsg();
extern char *dbfile();
extern FILE *_dbfopen();
extern void erasprmp();
extern void outscrf();
extern void output();
extern void pamt();
extern void pdate();
extern void pflt();
extern void phamt();
extern void plong();
extern void pshort();
extern void pstr();
extern void ptime();
extern void mv_cur();
extern void _inlsusp();
extern int inc();
extern int inl();
extern short _dt_today();
extern int _dt_year();
#ifdef UNIFY32
extern void _sdbrt();
#endif

#if defined(lint) && !defined(TERMCAP)
extern WINDOW *initscr();	/* I had always understood this was (int)?? */
#endif

#ifdef lint
#define getyx(win, y, x)	((y) = 0, (x) = 0)
#endif

/* Operational modes in logacl */

#define INQUIRE		010
#define ADD		004
#define MODIFY		002
#define DELETE		001

/* Used by the error functions */

extern char errcall[];

/* Ring menu definitions */

struct cmd {
	char c_key;
	char *c_title;
	char *c_desc;
};

#define EOM		'\0'	/* end of menu */
#define INVISIBLE	""	/* invisible entry */
