/*
 * $Header: upscrf.c,v 1.4 87/06/01 10:56:07 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	upscrf.c,v $
 * Revision 1.4  87/06/01  10:56:07  brandon
 * _sh_up only forced up; left as is if type doesn't have _UCF.
 * 
 * Revision 1.3  87/05/26  14:29:33  brandon
 * Well, utime() was the culprit (be nice if I could read!)-:
 * 
 * Revision 1.2  87/05/26  14:08:27  brandon
 * udate() conflicted with UN*X call; changed to upddate().
 * 
 * Revision 1.1  87/05/26  13:50:24  brandon
 * Initial revision
 * 
 * Revision 1.5  87/05/22  15:39:06  brandon
 * whoops!  It doesn't help to leave off the "break"'s in a switch().
 * 
 * Revision 1.4  87/05/12  17:19:19  brandon
 * Forgot to get rid of _UCF temporarily during type check
 * 
 * Revision 1.3  87/05/12  17:00:28  brandon
 * Enabled _UCF flag for type.
 * 
 * Revision 1.2  87/04/29  11:30:46  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT: upscrf() -- Take a type and (character) length, and call the
 * correct input routine for the type for UPDATE.
 *
 * DIFFERENCE FROM UNIFY:  In addition to the standard return codes, there are
 * a number of new ones.  If you want to use them, call setxrc() with a non-
 * zero argument.  The new codes are:
 *
 *		-5	ESC or ^E
 *		-6	ESC or ^E, returns buffer
 *		-7	^U or TAB, returns buffer
 *
 * Also, the following line-editing characters are supported:
 *
 *		^H		delete last charater
 *		^F		move forward (wraps to beginning)
 *		^B		move backward (wraps to end)
 *		^A		move to start of field
 *		^N		move to end of field
 *		^O		insert a space
 *		^D		delete a character
 *		^K		clear to end of field
 *		^X		exit program
 *		^R, ^L		redraw screen
 *		^P		shell out
 *
 * I would have used ^Z for end-of-field, but I see no reason to get the
 * people with job control or sxt's upset at me...
 */

int upscrf(x, y, type, len, buf)
char *buf; {
	int rc, oucf;

	setraw();
	mv_cur(1, x, y);
	oucf = _sh_up;
	if (type & _UCF)
		_sh_up = type & _UCF;
	type &= ~_UCF;
	switch (type) {
	case INT:
		rc = ushort(len, (short *) buf);
		break;
	case LONG:
		rc = ulong(len, (long *) buf);
		break;
	case AMT:
		rc = uamt(len, (long *) buf);
		break;
	case HAMT:
		rc = uhamt(len, (double *) buf);
		break;
	case STRNG:
		rc = ustr(len, buf);
		break;
	case DATE:
		rc = upddate((short *) buf);
		break;
	case HR:
		rc = updtime((short *) buf);
		break;
	case FLT:
		rc = uflt(len, (double *) buf);
		break;
	default:
		xerror(-1, "upscrf", "Unknown type %d", type);
		/*NOTREACHED*/
	}
	_sh_up = oucf;
	return rc;
}
