/*
 * $Header: uhamt.c,v 1.5 87/06/09 11:53:05 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	uhamt.c,v $
 * Revision 1.5  87/06/09  11:53:05  brandon
 * Right-justified buffer display; repositioned cursor after conversion errors.
 * 
 * Revision 1.4  87/06/01  08:37:39  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.3  87/05/27  14:42:45  brandon
 * Made sure buffer was padded with spaces.
 * 
 * Revision 1.2  87/05/26  15:44:18  brandon
 * Forgot to cast sprintf().
 * 
 * Revision 1.1  87/05/26  13:33:59  brandon
 * Initial revision
 * 
 * Revision 1.3  87/05/12  12:04:08  brandon
 * Changed to pass FWD, BACK, GO without checking the data buffer
 * 
 * Revision 1.2  87/04/29  11:30:37  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Input a huge amount, into a (double).
 */

int uhamt(len, buf)
register double *buf; {
	char ibuf[15];
	int rc, cnt, sign, dec, y, x;

	setraw();
	if (len > 14)
		len = 14;
	(void) sprintf(ibuf, "%*.2f", len + 3, *buf / 100.0);
	getyx(stdscr, y, x);
	for (;;) {
		(void) move(y, x);
		if ((rc = inl(ibuf, len, 0)) == BACK || rc == FWD || rc == GO || rc == LOOK)
			return rc;
		for (cnt = 0; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len) {
			prtmsg(1, 23, "Invalid amount");
			continue;
		}
		*buf = 0.0;
		sign = 0;
		dec = 0;
		if (ibuf[cnt] == '-') {
			sign = 1;
			if (++cnt == len) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
		}
		for (; cnt < len && isdigit(ibuf[cnt]); cnt++) {
			*buf *= 10.0;
			*buf += ibuf[cnt] - '0';
		}
		if (ibuf[cnt] == '.') {
			if (cnt > len - 2) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
			if (!isdigit(ibuf[++cnt])) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
			dec = (ibuf[cnt] - '0') * 10;
			if (!isdigit(ibuf[++cnt])) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
			dec += ibuf[cnt] - '0';
		}
		for (; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len)
 			break;
		prtmsg(1, 23, "Invalid amount");
	}
	*buf = *buf * 100.0 + dec;
	if (sign)
		*buf = - *buf;
	return rc;
}
