/*
 * $Header: uflt.c,v 1.5 87/06/09 11:53:03 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	uflt.c,v $
 * Revision 1.5  87/06/09  11:53:03  brandon
 * Right-justified buffer display; repositioned cursor after conversion errors.
 * 
 * Revision 1.4  87/06/01  08:37:36  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.3  87/05/27  14:42:30  brandon
 * Made sure buffer was padded with spaces.
 * 
 * Revision 1.2  87/05/26  15:44:16  brandon
 * Forgot to cast sprintf().
 * 
 * Revision 1.1  87/05/26  13:33:48  brandon
 * Initial revision
 * 
 * Revision 1.3  87/05/12  12:04:13  brandon
 * Changed to pass FWD, BACK, GO without checking the data buffer
 * 
 * Revision 1.2  87/04/29  11:30:35  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Input a float.  This time, they're dumb; take what we're given, no matter
 * how any decimals -- UNITRIEVE can figure it out for itself, since it won't
 * let me!  (This is UNIFY's own behavior, in fact.)
 */

int uflt(len, buf)
register double *buf; {
	char ibuf[18];
	int rc, cnt, sign, y, x;
	double dec;

	setraw();
	if (len > 17)
		len = 17;
	(void) sprintf(ibuf, "%*g", len, *buf);
	getyx(stdscr, y, x);
	for (;;) {
		(void) move(y, x);
		if ((rc = inl(ibuf, len, 0)) == BACK || rc == FWD || rc == GO || rc == LOOK)
			return rc;
		for (cnt = 0; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len) {
			prtmsg(1, 23, "Invalid float");
			continue;
		}
		*buf = 0.0;
		sign = 0;
		dec = 0;
		if (ibuf[cnt] == '-') {
			sign = 1;
			if (++cnt == len) {
				prtmsg(1, 23, "Invalid float");
				continue;
			}
		}
		for (; cnt < len && isdigit(ibuf[cnt]); cnt++) {
			*buf *= 10.0;
			*buf += ibuf[cnt] - '0';
		}
		if (ibuf[cnt] == '.') {
			dec = 10.0;
			for (cnt++; cnt < len && isdigit(ibuf[cnt]); cnt++) {
				*buf += (ibuf[cnt] - '0') / dec;
				dec *= 10.0;
			}
		}
		for (; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len)
 			break;
		prtmsg(1, 23, "Invalid float");
	}
	if (sign)
		*buf = - *buf;
	return rc;
}
