/*
 * $Header: udate.c,v 1.11 87/06/02 12:51:52 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	udate.c,v $
 * Revision 1.11  87/06/02  12:51:52  brandon
 * Linted.
 * 
 * Revision 1.10  87/06/01  16:29:20  brandon
 * Moved today() and thisyear() to datefns.c with new names.
 * 
 * Revision 1.9  87/06/01  09:39:27  brandon
 * Missing move() before pdate() calls.
 * 
 * Revision 1.8  87/06/01  09:25:26  brandon
 * AARGH! ! !  Output func is pdate(), not odate()!
 * 
 * Revision 1.7  87/06/01  09:23:01  brandon
 * Forced redisplay of entered date, so `/' (today) shows up properly.
 * 
 * Revision 1.6  87/06/01  08:37:30  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.5  87/05/27  15:51:59  brandon
 * Wasn't handling canonical form of NULLDATE.
 * 
 * Revision 1.4  87/05/27  14:42:24  brandon
 * Made sure buffer was padded with spaces.
 * 
 * Revision 1.3  87/05/26  15:44:12  brandon
 * Forgot to cast sprintf().
 * 
 * Revision 1.2  87/05/26  14:08:02  brandon
 * udate() conflicted with UN*X call; changed to upddate().
 * 
 * Revision 1.1  87/05/26  13:33:23  brandon
 * Initial revision
 * 
 * (Log: idate.c,v)
 * Revision 1.8  87/05/12  15:39:26  brandon
 * added call to _sdbrt() to insure correct date types
 * 
 * Revision 1.7  87/05/12  13:24:21  brandon
 * Dumb bugs in parsing /.
 * 
 * Revision 1.6  87/05/11  16:38:35  brandon
 * more checking and another bugfix; it was typechecking on no-data returns
 * 
 * Revision 1.5  87/05/11  16:30:07  brandon
 * more checking added (also friendlier error messages)
 * 
 * Revision 1.4  87/05/11  16:22:40  brandon
 * removed debugging and fixed bug!
 * 
 * Revision 1.3  87/05/11  16:13:54  brandon
 * bugchk
 * 
 * Revision 1.2  87/04/29  11:30:33  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#include <ctype.h>

/*
 * Input a date.  This is effectively a (short), but outside may have one of
 * the following values:
 *
 * 		n/n[/n]		**.**.**	*	/
 *
 * At any time, . or - may be used in place of /.  * is short for **.**.**;
 * / is short for today's date.  (Note:  I used . in place of / in the null
 * dates, the reason I leave as an exercise for the reader.)
 *
 * This routine is ugly, but it does it all.
 */

int upddate(buf)
short *buf; {
	int odate[3], date[3];
	int cnt, rc, DS1, DS2, DS3, x, y;
	char ibuf[9];

	setraw();
	_sdbrt();
	switch (_ldbrt & MASK_DATES) {
	case YMD:
		DS1 = YEAR;
		DS2 = MONTH;
		DS3 = DAY;
		break;
	case DMY:
		DS1 = DAY;
		DS2 = MONTH;
		DS3 = YEAR;
		break;
	case MDY:
		DS1 = MONTH;
		DS2 = DAY;
		DS3 = YEAR;
		break;
	default:
		xerror(-1, "udate", "Unrecognized internal date code %d", _ldbrt & MASK_DATES);
	}
	if (*buf == NULLDATE)
		(void) strcpy(ibuf, "**/**/**");
	else {
		kdate(*buf, date);
		(void) sprintf(ibuf, "%02d/%02d/%02d", date[DS1], date[DS2], date[DS3]);
	}
	getyx(stdscr, y, x);
	for (;;) {
		(void) move(y, x);
		if ((rc = inl(ibuf, 8, 0)) == BACK || rc == FWD || rc == GO || rc == LOOK)
			return rc;
		for (cnt = 0; cnt < 8; cnt++)
			if (ibuf[cnt] == '.' || ibuf[cnt] == '-')
				ibuf[cnt] = '/';
		for (cnt = 0; cnt < 8 && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == 8) {
			prtmsg(1, 23, "Invalid empty date");
			continue;
		}
		if (ibuf[cnt] == '/') {
			for (cnt++; cnt < 8 && ibuf[cnt] == ' '; cnt++)
				;
			if (cnt < 8) {
				prtmsg(1, 23, "Invalid date format");
				continue;
			}
			*buf = _dt_today();
			(void) move(y, x);
			pdate(buf);
			return rc;
		}
		if (ibuf[cnt] == '*') {
			if (strncmp(ibuf, "**/**/**", 8) == 0) {
				*buf = NULLDATE;
				(void) move(y, x);
				pdate(buf);
				return rc;
			}
			for (cnt++; cnt < 8 && ibuf[cnt] == ' '; cnt++)
				;
			if (cnt < 8) {
				prtmsg(1, 23, "Invalid null date format");
				continue;
			}
			*buf = NULLDATE;
			(void) move(y, x);
			pdate(buf);
			return rc;
		}
		if (!isdigit(ibuf[cnt])) {
			prtmsg(1, 23, "Invalid date -- bad digit");
			continue;
		}
		date[MONTH] = 0;
		date[DAY] = 0;
		date[YEAR] = 0;
		while (cnt < 8 && isdigit(ibuf[cnt])) {
			date[DS1] *= 10;
			date[DS1] += ibuf[cnt++] - '0';
		}
		if (cnt == 8 || ibuf[cnt++] != '/') {
			prtmsg(1, 23, "Invalid date -- invalid 1pt");
			continue;
		}
		while (cnt < 8 && isdigit(ibuf[cnt])) {
			date[DS2] *= 10;
			date[DS2] += ibuf[cnt++] - '0';
		}
		if (cnt < 8 && ibuf[cnt] == ' ') {
			for (; cnt < 8 && ibuf[cnt] == ' '; cnt++)
				;
			if (cnt < 8) {
				prtmsg(1, 23, "Invalid date -- trailing garbage");
				continue;
			}
			if (_ldbrt & YMD) {
				date[DAY] = date[MONTH];
				date[MONTH] = date[YEAR];
			}
			date[YEAR] = _dt_year();
		}
		else if (cnt == 8)
			date[YEAR] = _dt_year();
		else if (ibuf[cnt++] != '/') {
			prtmsg(1, 23, "Invalid date -- invalid 2pt");
			continue;
		}
		else {
			while (cnt < 8 && isdigit(ibuf[cnt])) {
				date[DS3] *= 10;
				date[DS3] += ibuf[cnt++] - '0';
			}
			if (cnt < 8) {
				for (; cnt < 8 && ibuf[cnt] == ' '; cnt++)
					;
				if (cnt < 8) {
					prtmsg(1, 23, "Invalid date -- trailing garbage in 3pt");
					continue;
				}
			}
		}
		*buf = kday(date);
		kdate(*buf, odate);
		if (ivcmp((char *) date, (char *) odate, sizeof date))
			break;
		prtmsg(1, 23, "Invalid date -- insane elements");
	}
	(void) move(y, x);
	pdate(buf);
	return rc;
}
