/*
 * $Header: pstr.c,v 1.3 87/06/03 14:05:11 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	pstr.c,v $
 * Revision 1.3  87/06/03  14:05:11  brandon
 * TRY qmove(), DUMMY!  :-)
 * 
 * Revision 1.2  87/06/03  13:51:32  brandon
 * Added workaround for UNITRIEVE nulls misfeature.
 * 
 * Revision 1.1  87/04/29  12:47:40  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Display a value of type STRNG.  This would be simple if not for the penchant
 * of UNITRIEVE to initialize STRNG fields to nulls....
 */

void pstr(len, buf)
char *buf; {
	char nulls[256];

	cfill(0, nulls, len);
	if (ivcmp(buf, nulls, len))
		cfill(' ', nulls, len);
	else
		qmove(buf, nulls, len);
	(void) setraw();
	(void) attron(A_UNDERLINE);
	(void) printw("%.*s", len, nulls);
	(void) attroff(A_UNDERLINE);
}
