/*
 * $Header: prtmsg.c,v 1.2 87/04/29 11:31:16 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	prtmsg.c,v $
 * Revision 1.2  87/04/29  11:31:16  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  prtmsg() -- Spit out a message in reverse video and wait for
 * a keypress.
 *
 * DIFFERENCE FROM UNIFY:  Typeahead is discarded.  This prevents the problems
 * we have with people typing faster than they are thinking.  :-)
 */

void prtmsg(x, y, str)
char *str; {
	setraw();
	(void) flushinp();
	(void) attrset(A_REVERSE);
	(void) mvprintw(y, x, " %s -> -> ", str);
	(void) attrset(0);
	(void) refresh();
	(void) getchar();
	(void) move(y, x);
	(void) clrtoeol();
	(void) refresh();	/* so it disappears immediately */
}
