/*
 * $Header: priamd.c,v 1.4 87/04/29 16:02:38 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	priamd.c,v $
 * Revision 1.4  87/04/29  16:02:38  brandon
 * Added a (void) cast to mvaddstr().
 * 
 * Revision 1.3  87/04/29  15:56:10  brandon
 * Added $UUACL handler
 * 
 * Revision 1.2  87/04/29  11:31:08  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#include <ctype.h>

extern int logacl;	/* access level, set from sysrecev */

/*
 * ENTRY POINT:  priamd() -- prompt for operational mode
 *
 * DIFFERENCE FROM UNIFY:  We no longer wait for a newline.  Also, the blocky
 * bleechy "[I]NQUIRE" type stuff is now "Inquire" which looks much nicer.
 */

priamd(line) {
	char cmdline[80], cmd[6];
	char ch;
	static int uuacl = -1;

	(void) mvaddstr(line, 1, "            ");
	if (uuacl == -1) {
		char *ep;

		if (logacl < 0 || logacl > 15)
			logacl = INQUIRE;
		if ((ep = getenv("UUACL")) == (char *) 0)
			uuacl = logacl;
		else if ((uuacl = atoi(ep)) <= 0 || uuacl > 15)
			uuacl = logacl;
		logacl = uuacl;
	}
	if (logacl == 0)
		return BACK;
	cmdline[0] = '\0';
	cmd[0] = '\0';
	if (logacl & INQUIRE) {
		(void) strcat(cmdline, "Inquire");
		(void) strcat(cmd, "I");
	}
	if (logacl & ADD) {
		if (cmdline[0] != '\0')
			(void) strcat(cmdline, ", ");
		(void) strcat(cmdline, "Add");
		(void) strcat(cmd, "A");
	}
	if (logacl & MODIFY) {
		if (cmdline[0] != '\0')
			(void) strcat(cmdline, ", ");
		(void) strcat(cmdline, "Modify");
		(void) strcat(cmd, "M");
	}
	if (logacl & DELETE) {
		if (cmdline[0] != '\0')
			(void) strcat(cmdline, ", ");
		(void) strcat(cmdline, "Delete");
		(void) strcat(cmd, "D");
	}
	(void) strcat(cmdline, "? ");
	(void) mvaddstr(22, 1, cmdline);
	for (;; (void) beep()) {
		ch = toupper(getchar() & 0x7f);
		if (ch == '\0')
			continue;
		if (ch == '\t' || ch == '\025') {
			(void) addch('\r');
			(void) clrtoeol();
			return BACK;
		}
		if (strchr(cmd, ch) != (char *) 0)
			break;
	}
	(void) addch('\r');
	(void) clrtoeol();
	switch (ch) {
	case 'I':
		(void) mvaddstr(line, 1, "Inquire mode");
		return 0;
	case 'A':
		(void) mvaddstr(line, 1, "Add mode");
		return 1;
	case 'M':
		(void) mvaddstr(line, 1, "Modify mode");
		return 2;
	case 'D':
		(void) mvaddstr(line, 1, "Delete mode");
		return 3;
	}
	xerror(-1, "priamd", "Illegal internal state %c", ch);
	/*NOTREACHED*/
}
