/*
 * $Header: pdata.c,v 1.1 87/04/29 13:51:45 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	pdata.c,v $
 * Revision 1.1  87/04/29  13:51:45  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  pdata() -- Display data from database fields
 *
 * DIFFERENCE FROM UNIFY:  FLT is FUBAR; see pflt.c.
 */

void pdata(x, y, fld) {
	char fbuf[256];
	FLDESC fd;

	if (!fldesc(fld, &fd))
		xerror(-1, "pdata", "Unknown database field %d", fld);
	if (fd.f_typ == COMB)
		xerror(-2, "pdata", "COMB field %d illegal", fld);
	if (gfield(fld, fbuf) != 0)
		xerror(-3, "pdata", "Read access for field %d denied", fld);
	outscrf(x, y, fd.f_typ, fd.f_len, fbuf);
}
