/*
 * $Header: pageout.c,v 1.1 87/04/29 17:04:47 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	pageout.c,v $
 * Revision 1.1  87/04/29  17:04:47  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * A simple pager, along the lines of that built in to SSQL and the menu
 * manager.
 */

void pageout(fp, title)
FILE *fp;
char *title; {
	int ch, col, line;

	(void) move(2, 0);
	(void) attron(A_REVERSE);
	(void) addstr(title);
	(void) attroff(A_REVERSE);
	(void) addch('\n');
	line = 3;
	col = 0;
	while ((ch = getc(fp)) != EOF) {
		(void) move(line, col);
		switch (ch) {
		case '\n':
			(void) attroff(A_UNDERLINE);
			(void) addch('\n');
			if (++line == LINES - 1) {
				(void) attron(A_REVERSE);
				(void) addstr(" More?  Press any key to continue or Q to quit. ");
				(void) attroff(A_REVERSE);
				(void) refresh();
				switch (getchar() & 0x7f) {
				case 'q':
				case 'Q':
					line = -1;
					break;
				default:
					line = 3;
					break;
				}
				(void) addch('\r');
				(void) clrtoeol();
			}
			break;
		case '\b':
			(void) addch('\b');
			(void) attron(A_UNDERLINE);
			if (col > 0)
				col--;
			continue;
		case '\t':
			do {
				(void) addch(' ');
				(void) attroff(A_UNDERLINE);
				if (++col == COLS) {
					col = 0;
					++line;
					break;
				}
			} while (col % 8 != 0);
			if (line == LINES - 1) {
				(void) attron(A_REVERSE);
				(void) addstr(" More?  Press any key to continue or Q to quit. ");
				(void) attroff(A_REVERSE);
				(void) refresh();
				switch (getchar() & 0x7f) {
				case 'q':
				case 'Q':
					line = -1;
					break;
				default:
					line = 3;
					break;
				}
				(void) addch('\r');
				(void) clrtoeol();
			}
			break;
		case '\r':
			col = 0;
			(void) addch('\r');
			(void) attroff(A_UNDERLINE);
			break;
		default:
			if (ch < ' ' || ch > '~')
				ch = ' ';
			(void) addch(ch);
			(void) attroff(A_UNDERLINE);
			if (++col < COLS)
				break;
			col = 0;
			if (++line == LINES - 1) {
				(void) attron(A_REVERSE);
				(void) addstr(" More?  Press any key to continue or Q to quit. ");
				(void) attroff(A_REVERSE);
				(void) refresh();
				switch (getchar() & 0x7f) {
				case 'q':
				case 'Q':
					line = -1;
					break;
				default:
					line = 3;
					break;
				}
				(void) addch('\r');
				(void) clrtoeol();
			}
			break;
		}
		if (line == -1)
			break;
	}
	if (line == -1 || (line == 3 && col == 0))
		return;
	prtmsg(1, 23, "Completed.  Press RETURN to continue");
}
