/*
 * $Header: mv_cur.c,v 1.2 87/04/29 11:31:01 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	mv_cur.c,v $
 * Revision 1.2  87/04/29  11:31:01  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  mv_cur() -- move cursor on a given fd
 *
 * DIFFERENCE FROM UNIFY:  If fd isn't 1, you get a run-time error; use the
 * old library if you want funny terminal stuff, or else hook into terminfo-
 * based curses and call newterm().  I daresay nobody uses the fd hook anyway.
 */

void mv_cur(fd, x, y) {
	if (fd != 1)
		xerror(-1, "eras_ln", "Multi-terminal operation on fd %d not supported", fd);
	if (move(y, x) == ERR)
		xerror(-1, "mv_cur", "(%d, %d) cursor position is off the screen", x, y);
}
