/*
 * $Header: loadscr.c,v 1.8 87/06/11 15:21:36 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	loadscr.c,v $
 * Revision 1.8  87/06/11  15:21:36  brandon
 * Wasn't checking the display length against the actual length of fields.
 * 
 * Revision 1.7  87/05/12  11:22:52  brandon
 * Forgot to move to the screen field position before underlining!
 * 
 * Revision 1.6  87/05/11  17:01:36  brandon
 * dumb bug (sf_type???)
 * 
 * Revision 1.5  87/05/11  16:54:57  brandon
 * added code to underline screen fields initially
 * 
 * Revision 1.4  87/05/11  15:30:09  brandon
 * chekcs removed, loadscr() works
 * 
 * Revision 1.3  87/05/11  15:26:34  brandon
 * added a hook to find a bug in sfield handling
 * 
 * Revision 1.2  87/04/29  11:30:57  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

struct q *__scf = (struct q *) 0;
int __nsf = 0;
int _sh_up = 0;

/*
 * Display a string, handling ~-escapes and null-terminating.
 */

static void mvspit(y, x, s, l)
char *s; {
	int c;

#ifdef UNIFY32
	_sdbrt();	/* get bracket & date information */
#endif
	for (c = l - 1; s[c] == ' '; c--)
		if (c == 0)
			return;
	s[++c] = '\0';
	(void) move(y, x);
	for (c = 0; s[c] != '\0'; c++)
		if (s[c] != '~') {
#ifdef UNIFY32
			if (_ldbrt & UNITED_STATES)
				(void) addch(s[c]);
			else
				switch (s[c]) {
				case '[':
					(void) addch('(');
					break;
				case '(':
					(void) addch('[');
					break;
				case ')':
					(void) addch(']');
					break;
				case ']':
					(void) addch(')');
					break;
				default:
					(void) addch(s[c]);
				}
#else
			(void) addch(s[c]);
#endif
		} else
			switch (s[++c]) {
			case 'r':
				(void) attron(A_REVERSE);
				break;
			case 's':
				(void) attroff(A_REVERSE);
				break;
			case 'u':
				(void) attron(A_UNDERLINE);
				break;
			case 'v':
				(void) attroff(A_UNDERLINE);
				break;
			case 'w':
				(void) attron(A_REVERSE|A_UNDERLINE);
				break;
			case 'x':
				(void) attroff(A_REVERSE|A_UNDERLINE);
				break;
			case '\0':
				c--;
				break;
			default:
				break;
			}
}

/*
 * ENTRY POINT:  loadscr() -- Load and display a screen .q file.
 *
 * DIFFERENCE FROM UNIFY:  None.
 */

void loadscr(s)
char *s; {
	FLDESC fd;
	FILE *fp;
	char *sf;
	int cnt;

	setraw();
	if (__scf != (struct q *) 0)
		free((char *) __scf);
	__nsf = 0;
	if ((sf = dbfile(s, "q")) == (char *) 0)
		xerror(-1, "loadscr", "Cannot find screen %s", s);
	if ((fp = fopen(sf, "r")) == (FILE *) 0)
		xerror(-2, "loadscr", "Cannot open screen %s", s);
	(void) fseek(fp, 0L, 2);
	if (ftell(fp) == 0L)
		return;	/* empty??? */
	if ((__scf = (struct q *) malloc((unsigned int) (__nsf = (int) ftell(fp)))) == (struct q *) 0)
		xerror(-3, "loadscr", "Out of memory");
	rewind(fp);
	__nsf /= sizeof *__scf;
	if (fread((char *) __scf, (int) sizeof *__scf, __nsf, fp) != __nsf)
		xerror(-4, "loadscr", "Read error on screen %s", s);
	for (cnt = 0; cnt < __nsf; cnt++) {
		if (__scf[cnt].q_fld == 0)
			continue;
		if (!fldesc(__scf[cnt].q_fld, &fd))
			xerror(-5, "loadscr", "Invalid database field %.*s", sizeof __scf[cnt].q_dbfld, __scf[cnt].q_dbfld);
		if (fd.f_typ != __scf[cnt].q_type)
			xerror(-6, "loadscr", "Database field %.*s type has changed -- recompile screen", sizeof __scf[cnt].q_dbfld, __scf[cnt].q_dbfld);
		if (fd.f_len != xsize(__scf[cnt].q_type, __scf[cnt].q_len))
			xerror(-7, "loadscr", "Database field %.*s length has changed -- recompile screen", sizeof __scf[cnt].q_dbfld, __scf[cnt].q_dbfld);
	}
	(void) erase();
	for (cnt = 0; cnt < __nsf; cnt++) {
		mvspit(__scf[cnt].q_py, __scf[cnt].q_px, __scf[cnt].q_prmp, sizeof __scf[cnt].q_prmp);
		if (__scf[cnt].q_type != 0) {
			(void) move(__scf[cnt].q_fy, __scf[cnt].q_fx);
			(void) attron(A_UNDERLINE);
			(void) printw("%*s", xsize(__scf[cnt].q_type, __scf[cnt].q_len), "");
			(void) attroff(A_UNDERLINE);
		}
	}
}
