/*
 * $Header: input.c,v 1.3 87/04/29 11:44:40 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	input.c,v $
 * Revision 1.3  87/04/29  11:44:40  brandon
 * Added _UCF upshifting.  See also inbuf.c, xsfldesc.c.  (The comment in
 * inbuf.c is WRONG!)
 * Also caused error on screen field w/o database field.
 * 
 * Revision 1.2  87/04/29  11:30:44  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  input() -- Get data from a screen field and store it in
 * the database.
 *
 * DIFFERENCE FROM UNIFY:  See gdata().
 */

input(sfld) {
	int rc, ousf;

	if (sfld < 0 || sfld >= __nsf)
		xerror(-1, "input", "Invalid screen field %d", sfld);
	if (__scf[sfld].q_fld == 0)
		xerror(-2, "input", "Screen field %d has no associated database field", sfld);
	ousf = _sh_up;
	_sh_up = __scf[sfld].q_type & _UCF;
	rc = gdata(__scf[sfld].q_fx, __scf[sfld].q_fy, __scf[sfld].q_fld);
	_sh_up = ousf;
	return rc;
}
