/*
 * $Header: incs.c,v 1.5 87/06/03 11:39:50 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	incs.c,v $
 * Revision 1.5  87/06/03  11:39:50  brandon
 * Added XRC_NOFLSH so incs() can be used by functions which build temporary
 * windows; otherwise, the main window might be refresh()ed over the temp
 * window, destroying it.
 * 
 * Revision 1.4  87/06/02  18:40:09  brandon
 * Added XRC_FWDGO:  RETURN normally is interpreted as FWD, if XRC_FWDGO then
 * RETURN is interpreted as GO.
 * 
 * Revision 1.3  87/06/02  14:22:37  brandon
 * Added XRC_CHAR to return normal characters; this contradicts the original
 * reason for incs(), but makes it more useful.  This effectively renders
 * inc() unused; it is retained as a character-input-with-echo primitive.
 * 
 * Revision 1.2  87/06/02  12:16:24  brandon
 * Forgot to change shellout() to _inlsusp().
 * 
 * Revision 1.1  87/06/01  16:48:39  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Input primitive.  Get a single input character, accepting status returns
 * only.  This is used when only the control characters are wanted, not any
 * real input.  The argument is an XRC flag, valid only for the duration of
 * the function.
 */

int incs(xrc)
int xrc; {
	int ch;

	setraw();
	if ((xrc & XRC_NOFLSH) == 0)
		(void) refresh();
	for (;;) {
		ch = getchar() & 0x7f;
		switch (ch) {
		case '\033':
		case '\005':
			if (xrc & XRC_GO)
				return GO;
			(void) beep();
			break;
		case '\t':
		case '\025':
			return BACK;
		case '\n':
		case '\r':
			if (xrc & XRC_FWDGO)
				return GO;
			/*FALLTHROUGH*/
		case ' ':
			return FWD;
		case '\b':
			if (xrc & XRC_BKSP)
				return BKSP;
			(void) beep();
			break;
		case '\006':
			if (xrc & XRC_CFB)
				return CFWD;
			(void) beep();
			break;
		case '\002':
			if (xrc & XRC_CFB)
				return CBACK;
			(void) beep();
			break;
		case '\026':
			if (xrc & XRC_LOOK)
				return LOOK;
			(void) beep();
			break;
		case '\030':
			(void) move(LINES - 1, 0);
			(void) clrtoeol();
			(void) refresh();
			(void) endwin();
			exit(0);
		case '\020':
			_inlsusp();
			break;
		case '\f':
		case '\022':
			(void) clearok(curscr);
			(void) wrefresh(curscr);
			break;
		default:
			if ((xrc & XRC_CHAR) && ch > '!' && ch < '\177')
				return ch;
			(void) beep();
			break;
		}
	}
}
