/*
 * $Header: gprint.c,v 1.2 87/06/02 12:51:46 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	gprint.c,v $
 * Revision 1.2  87/06/02  12:51:46  brandon
 * Linted.
 * 
 * Revision 1.1  87/06/01  08:28:48  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Generate a printable version of a database field.  This is similar to dspdt
 * but works for any data type.
 */

void uttoa(buf, typ, len, xbuf)
char *buf, *xbuf; {
#ifndef UNIFY32
	int date[3];
#endif UNIFY32

	switch (typ) {
	case INT:
		(void) sprintf(buf, "%*d", len, *((short *) xbuf));
		break;
	case LONG:
		(void) sprintf(buf, "%*ld", len, *((long *) xbuf));
		break;
	case AMT:
		(void) sprintf(buf, "%*.2f", len, (double) *((long *) xbuf) / 100.0);
		break;
	case HAMT:
		(void) sprintf(buf, "%*.2f", len, *((double *) xbuf) / 100.0);
		break;
	case STRNG:
		(void) sprintf(buf, "%-*.*s", len, len, xbuf);
		break;
	case FLT:
		(void) sprintf(buf, "%*g", len, *((double *) xbuf));
		break;
	case DATE:
#ifdef UNIFY32
		dspdt(*((short *) xbuf), buf);
		buf[8] = '\0';
#else
		kdate(*((short *) buf), date);
		(void) sprintf(buf, "%02d/%02d/%02d", date[MONTH], date[DAY], date[YEAR]);
#endif UNIFY32
		break;
	case HR:
		(void) sprintf(buf, "%02d:%02d", *((short *) xbuf) / 100, *((short *) xbuf) % 100);
		break;
	default:
		xerror(-1, "uttoa", "Unknown or illegal type %d", typ);
	}
}

gprint(fld, fbuf)
char *fbuf; {
	char buf[256];
	FLDESC fd;

	if (!fldesc(fld, &fd))
		xerror(-1, "gprint", "Unrecognized field %d", fld);
	if (gfield(fld, buf) == -1)
		return -1;
	uttoa(fbuf, fd.f_typ, fd.f_len, buf);
	return 0;
}
