/*
 * $Header: gdata.c,v 1.3 87/05/27 16:01:59 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	gdata.c,v $
 * Revision 1.3  87/05/27  16:01:59  brandon
 * Had a break; on failed exp. rel. that should have been a continue;.
 * 
 * Revision 1.2  87/04/29  11:30:26  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  gdata() -- get a value at a specified location and store it
 * in the database.
 *
 * DIFFERENCE FROM UNIFY:  See inscrf().  Also, if a pfield() fails, the
 * operation will be retried as follows:
 *
 *	record locked:	asks retry or abort -- the latter acts as a -3
 *	no access:	asks for a password, wrong acts as -3 return
 */

gdata(fx, fy, field) {
	char buf[256];
	int rc, ch;

	setraw();
	for (;;) {
		rc = gtube(fx, fy, field, buf);
		if (rc == BACK || rc == FWD || rc == GO) {
			if (rc == FWD)
				rc = FWD_OK;
			break;
		}

repass:
		switch (ch = pfield(field, buf)) {
		case -4:
			(void) mvprintw(23, 1, "Enter modify password for field: ");
			(void) refresh();
			(void) nocbreak();
			(void) nl();
			if (accsfld(field, getpass(""), 'w') == 0)
				goto repass;
			(void) noecho();
			(void) cbreak();
			(void) nonl();
			prtmsg(1, 23, "Wrong password");
			rc = -3;
			break;
		case -5:
			(void) mvprintw(23, 1, "Record is locked -- Retry or Abort? ");
			(void) refresh();
			ch = tolower(getchar() & 0x7f);
			(void) move(23, 1);
			(void) clrtoeol();
			switch (ch) {
			case 'a':
				rc = -3;
				break;
			default:
				goto repass;
			}
			break;
		case 0:
			break;
		case -1:
			prtmsg(1, 23, "Record is referenced, you may not change the key");
			continue;
		case -2:
			prtmsg(1, 23, "This field has a unique index, and the value you entered exists");
			continue;
		case -3:
			prtmsg(1, 23, "There is no related record with this key");
			continue;
		default:
			xerror(-1, "gtube", "Unknown error %d from pfield", ch);
		}
		break;
	}
	return rc;
}
