/*
 * $Header: zoom.c,v 1.11 87/06/09 12:34:44 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	zoom.c,v $
 * Revision 1.11  87/06/09  12:34:44  brandon
 * OOPS!  Wanted wattroff(), *used* attroff().... sigh.
 * 
 * Revision 1.10  87/06/09  12:31:57  brandon
 * Added RV "cursor"; fixed clearing on last page.
 * 
 * Revision 1.9  87/06/03  13:17:30  brandon
 * Fixed final paging bugs; now full functional.
 * 
 * Revision 1.8  87/06/03  11:10:01  brandon
 * Added extra refresh() so the cursor will end up in the NEW window.  I hope.
 * 
 * Revision 1.7  87/06/02  12:51:55  brandon
 * Linted.
 * 
 * Revision 1.6  87/06/02  12:34:22  brandon
 * Linted.
 * 
 * Revision 1.5  87/06/02  12:16:40  brandon
 * Changed error() to xerror(); also ifdefed for Unify 3.2 (it won't work under
 * earlier versions, since it uses the new data dictionary access calls).
 * 
 * Revision 1.4  87/06/01  16:43:29  brandon
 * Now uses incs() (input character by status code) instead of getchar().
 * 
 * Revision 1.3  87/06/01  10:05:16  brandon
 * Made sure current-record cursor stayed in place on FWD from last record.
 * 
 * Revision 1.2  87/06/01  09:35:01  brandon
 * Added touchwin() to fix curses bug with missing touchwin() in delwin().
 * (This bug is actually a holdover from the old curses.??!)
 * 
 * Revision 1.1  87/06/01  08:31:27  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#ifndef UNIFY32
#ifndef lint
static char dummy = '\0';	/* dumb loaders (Sys III) need this, alas */
#endif
#else

#include "usc.h"
#ifdef TG
#include "tgraph.h"
#else
#ifndef ACS_HLINE
#define ACS_HLINE	'-'
#define ACS_VLINE	'|'
#define ACS_LLCORNER	'`'
#define ACS_ULCORNER	','
#define ACS_LRCORNER	'\''
#define ACS_URCORNER	'.'
#define ACS_TTEE	'+'
#define ACS_BTEE	'+'
#endif
#endif

extern char *fldsyn();
extern long atol();

/*
 * When XRC_LOOK is enabled and ^V is entered in a field with an explicit
 * relationship, zoom() is invoked to display a browse window.  The user may
 * then move around within the window, select a record, and return, which
 * causes that record's key to be entered as the value of the field.
 *
 *	TAB	move up one record
 *	RET	move down one record
 *	^F	move forward one page
 *	^B	move back
 *	^V	exit without returning a value
 *	ESC	exit and return key of current record
 */

zoom(x, y, fld, fdp, buf)
FLDESC *fdp;
char *buf; {
	WINDOW *w;
	int nfld, bfld, cnt, len, ier;
	int *bwf;
	long myloc, endloc, pageloc, lastrec;
	FLDESC fd;
	char xbuf[256];

	nfld = 0;
	for (bfld = numflds(); bfld > 0; bfld--)
		if (fldesc(bfld, &fd) && fd.f_rec == fdp->f_rprec && fd.f_typ != COMB)
			nfld++;
	if ((bwf = (int *) malloc((unsigned) (nfld + 1) * sizeof *bwf)) == (int *) 0)
		xerror("zoom", 0, "out of memory at field %d", fld);
	bwf[nfld--] = 0;
	for (bfld = numflds(); bfld > 0; bfld--)
		if (fldesc(bfld, &fd) && fd.f_rec == fdp->f_rprec && fd.f_typ != COMB)
			bwf[nfld--] = bfld;
	len = 3;
	for (nfld = 0; bwf[nfld] != 0; nfld++) {
		(void) fldesc(bwf[nfld], &fd);
		if ((bfld = strlen(fldsyn(bwf[nfld]))) > fd.f_len)
			fd.f_len = bfld;
		if ((len += fd.f_len + 1) >= COLS)
			break;
	}
	if (bwf[nfld] != 0) {
		len -= fd.f_len + 1;
		bwf[nfld] = 0;
	}
	if (LINES - y < 5)
		y = LINES - 5;
	if ((x -= len - 2) < 0)
		x = 0;
	if ((w = newwin(LINES - y - 1, len, y, x)) == (WINDOW *) 0)
		xerror("zoom", 0, "can't allocate window");
	/* now ready to display stuff in our pet window */
#ifdef TG
	graph("");
#endif
	(void) box(w, ACS_VLINE, ACS_HLINE);
	(void) mvwaddch(w, 0, 0, ACS_ULCORNER);
	(void) mvwaddch(w, LINES - y - 2, 0, ACS_LLCORNER);
	(void) mvwaddch(w, LINES - y - 2, len - 1, ACS_LRCORNER);
	(void) mvwaddch(w, 0, len - 1, ACS_URCORNER);
	cnt = 2;
	for (nfld = 0; bwf[nfld + 1] != 0; nfld++) {
		(void) fldesc(bwf[nfld], &fd);
		if ((bfld = strlen(fldsyn(bwf[nfld]))) > fd.f_len)
			fd.f_len = bfld;
		cnt += fd.f_len;
		(void) mvwaddch(w, 0, cnt, ACS_TTEE);
		(void) mvwaddch(w, LINES - y - 2, cnt, ACS_BTEE);
		cnt++;
	}
	(void) wmove(w, 1, 2);
	for (nfld = 0; bwf[nfld] != 0; nfld++) {
		(void) fldesc(bwf[nfld], &fd);
		if ((bfld = strlen(fldsyn(bwf[nfld]))) > fd.f_len)
			fd.f_len = bfld;
		(void) wattron(w, A_UNDERLINE);
		(void) wprintw(w, "%-*.*s", fd.f_len, fd.f_len, fldsyn(bwf[nfld]));
		(void) wattroff(w, A_UNDERLINE);
		if (bwf[nfld + 1] != 0)
			(void) waddch(w, ACS_VLINE);
	}
	myloc = 1;
	pageloc = 1;
	lastrec = sort(fdp->f_rprec);
	for (;;) {
		cnt = 2;
		endloc = pageloc;
		for (ier = sethere(fdp->f_rprec, pageloc); cnt < LINES - y - 2 && ier == 0; ier = sethere(fdp->f_rprec, ++endloc)) {
			(void) mvwaddch(w, cnt, 1, ' ');
			for (nfld = 0; bwf[nfld] != 0; nfld++) {
				(void) fldesc(bwf[nfld], &fd);
				(void) gprint(bwf[nfld], xbuf);
				if ((bfld = strlen(fldsyn(bwf[nfld]))) > fd.f_len)
					fd.f_len = bfld;
				if (myloc == endloc)
					(void) wattron(w, A_STANDOUT);
				(void) wprintw(w, "%-*.*s", fd.f_len, fd.f_len, xbuf);
				if (myloc == endloc)
					(void) wattroff(w, A_STANDOUT);
				if (bwf[nfld + 1] != 0)
					(void) waddch(w, ACS_VLINE);
			}
			cnt++;
		}
		endloc--;
/*		if (myloc < pageloc || myloc > endloc)
			myloc = pageloc;	*/
		while (cnt < LINES - y - 2) {
			(void) mvwaddch(w, cnt, 1, ' ');
			for (nfld = 0; bwf[nfld] != 0; nfld++) {
				(void) fldesc(bwf[nfld], &fd);
				if ((bfld = strlen(fldsyn(bwf[nfld]))) > fd.f_len)
					fd.f_len = bfld;
				(void) wprintw(w, "%*s", fd.f_len, "");
				if (bwf[nfld + 1] != 0)
					(void) waddch(w, ACS_VLINE);
			}
			cnt++;
		}
		cnt = myloc - pageloc;
		(void) wattron(w, A_STANDOUT);
		(void) mvwaddch(w, 2 + cnt, 1, '>');
		(void) wattroff(w, A_STANDOUT);
		(void) wmove(w, 2 + cnt, 1);
		(void) refresh();	/* so the next one places the cursor */
		(void) wrefresh(w);
		ier = 0;
		switch (incs(XRC_GO|XRC_LOOK|XRC_CFB|XRC_NOFLSH)) {
		case GO:
			if ((ier = sethere(fdp->f_rprec, myloc)) != 0) {
				prtmsg(1, 23, "Record not available");
				continue;
			}
			(void) gfield(fdp->f_rpfld, buf);
			ier = 1;
			/*FALLTHROUGH*/
		case LOOK:
			unsort(fdp->f_rprec);
			(void) delwin(w);
			(void) touchwin(stdscr);
			free((char *) bwf);
			return (ier? OK: FWD);
		case FWD:
			if (++myloc <= endloc)
				break;
			if (myloc > lastrec)
				myloc = lastrec;
			/*FALLTHROUGH*/
		case CFWD:
			if ((pageloc += LINES - y - 4) > lastrec) {
				prtmsg(1, 23, "There is no next page");
				pageloc -= LINES - y - 4;
			}
			break;
		case BACK:
			if (--myloc >= pageloc)
				break;
			if (myloc < 0)
				myloc = 0;
			/*FALLTHROUGH*/
		case CBACK:
			if ((pageloc -= LINES - y - 4) < 1) {
				prtmsg(1, 23, "There is no previous page");
				pageloc = 1;
			}
			break;
		default:
			(void) beep();
		}
	}
}

/*****************************************************************************/

static FILE *_F_ = (FILE *) 0;
static int   _S_ =          0;

sort(r) {
	int ier, key;
	long nrec, here;
	FLDESC fd;
	char buf[1024], t[50];

	if (_F_ != (FILE *) 0)
		unsort(r);
	(void) sprintf(t, "/tmp/,zt%05d", getpid());
	if ((_F_ = fopen(t, "w")) == (FILE *) 0)
		xerror("zoomsort", 0, "cannot create tag file %s", t);
	(void) fldesc(key = reckey(r), &fd);
	nrec = 0L;
	for (ier = seqacc(r, 1); ier == 0; ier = seqacc(r, 2)) {
		nrec++;
		(void) gprint(key, buf);
		(void) loc(r, &here);
		(void) sprintf(buf + fd.f_len, "%09ld\n", here);
		(void) fputs(buf, _F_);
	}
	(void) fclose(_F_);
	switch (fork()) {
	case -1:
		xerror("zoomsort", 0, "cannot fork");
	case 0:
		(void) sprintf(buf, "-0.%d", fd.f_len);
		(void) execlp("sort", "sort", "+0", buf, t, "-o", t, (char *) 0);
		_exit(-1);
	default:
		(void) wait((int *) 0);
	}
	if ((_F_ = fopen(t, "r")) == (FILE *) 0)
		xerror("zoomsort", -1, "cannot reopen tagfile %s", t);
	(void) unlink(t);
	_S_ = fd.f_len + 10;
	return nrec;
}

unsort(r) {
	(void) fclose(_F_);
	_F_ = (FILE *) 0;
	_S_ = 0;
}

sethere(r, pos)
long pos; {
	char buf[1024];

	(void) fseek(_F_, (pos - 1) * _S_, 0);
	if (fgets(buf, sizeof buf, _F_) == (char *) 0)
		return -1;
	return setloc(r, atol(buf + _S_ - 10));
}

#endif
