/*
 * $Header: xerror.c,v 1.9 87/05/29 10:53:45 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	xerror.c,v $
 * Revision 1.9  87/05/29  10:53:45  brandon
 * Have to deal with an error before the screen is set up (was dumping core on
 * endwin() with stdscr == NULL).
 * 
 * Revision 1.8  87/05/12  10:57:56  brandon
 * Tried a better way of resetting to standard terminal mode.
 * 
 * Revision 1.7  87/05/11  17:03:57  brandon
 * oops!  "errprog" -> "errcall"
 * 
 * Revision 1.6  87/05/11  16:57:44  brandon
 * added an error hook (primary use is to dump core on error exit)
 * 
 * Revision 1.5  87/05/11  14:12:33  brandon
 * rearranged order of echo() kludge and other I/O routines to make sure it
 * takes
 * 
 * Revision 1.4  87/05/11  13:32:41  brandon
 * echo() call conflicts with unify; changed to system("stty echo") [UGH!]
 * 
 * Revision 1.3  87/05/01  16:15:06  brandon
 * V_prgnm turned out to be defined in libx.a (unify).
 * 
 * Revision 1.2  87/04/29  11:31:27  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#include <varargs.h>

/*
 * Error log operations.  We try to emulate UNIFY 3.2's error log stuff, but
 * it's not absolutely essential that we succeed (thankfully).
 *
 * A side benefit of this for pre-3.2 users is that the error log is used
 * regardless of the UNIFY version.  (The error log should have been in the
 * first version of UNIFY.)
 */

extern int errno;
extern char *V_prgnm;

char errcall[30] = "xerror";
void (*errhook)() = (void (*)()) 0;

/*VARARGS*/
xerror(va_alist)
va_dcl {
	va_list args;
	int ier;
	char *fnm, *fmt;
	FILE *errlog;
	long now;

	if (stdscr != (WINDOW *) 0)
		(void) endwin();
	va_start(args);
	ier = va_arg(args, int);
	fnm = va_arg(args, char *);
	fmt = va_arg(args, char *);
	if ((errlog = _dbfopen("errlog", "a")) == (FILE *) 0) {
		errlog = stderr;
		(void) fprintf(stderr, "\r\nInternal error %d/%d from %s: ", ier, errno, fnm);
	}
	else {
		now = time((long *) 0);
		(void) fprintf(errlog, "\n***\n\n%s\nProgram: %s\nCalling function: %s\nOffending function: %s\nStatus: %d\nErrno: %d\nNotes: ",
			ctime(&now), V_prgnm, errcall, fnm, ier, errno);
		(void) fprintf(stderr, "\r\nAn internal program error has occurred.  Please see the error log for details.\r\n\r\n\r\n");
	}
	(void) vfprintf(errlog, fmt, args);
	va_end(args);
	if (errlog == stderr)
		(void) fprintf(stderr, "\r\n\r\n");
	else
		(void) putc('\n', errlog);
	if (errhook != (void (*)()) 0)
		(*errhook)(ier, fnm, errcall);
	exit(99);
}
