/*
 * $Header: upbuf.c,v 1.1 87/05/26 13:49:35 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	upbuf.c,v $
 * Revision 1.1  87/05/26  13:49:35  brandon
 * Initial revision
 * 
 * Revision 1.5  87/04/29  14:19:12  brandon
 * FLT display length is sfield length / 10
 * 
 * Revision 1.4  87/04/29  13:17:22  brandon
 * The code to convert internal to display lengths was in gtube(); it belonged
 * in here, so here it is.
 * 
 * Revision 1.3  87/04/29  11:40:50  brandon
 * Added ability to OR an upshift flag with a screen field type to get auto
 * upshifting on certain screen fields.  See also gdata.c.
 * 
 * Revision 1.2  87/04/29  11:30:40  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  upbuf() -- Update from a screen field to a buffer
 *
 * DIFFERENCE FROM UNIFY:  See upscrf().
 */

upbuf(sfld, buf)
char *buf; {
	int rc, oucf, len;

	setraw();
	if (sfld < 0 || sfld > __nsf)
		xerror(-1, "upbuf", "Invalid screen field %d", sfld);
	oucf = _sh_up;
	_sh_up = __scf[sfld].q_type & _UCF;
	/* This code was in gtube(), because I screwed up! */
	len = __scf[sfld].q_len;
	switch (__scf[sfld].q_type) {
	case INT:
	case LONG:
	case STRNG:
		break;
	case AMT:
	case HAMT:
		len += 3;
		break;
	case DATE:
		len = 8;
		break;
	case HR:
		len = 5;
		break;
	case FLT:
		len /= 10;
		break;
	case COMB:
		xerror(-2, "upbuf", "COMB field %d illegal", sfld);
	}
	if (__scf[sfld].q_fld != 0)
		rc = uptube(__scf[sfld].q_fx, __scf[sfld].q_fy, __scf[sfld].q_fld, buf);
	else
		rc = upscrf(__scf[sfld].q_fx, __scf[sfld].q_fy, __scf[sfld].q_type & ~_UCF, len, buf);
	_sh_up = oucf;
	return rc;
}
