/*
 * $Header: shellout.c,v 1.4 87/06/17 17:40:53 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	shellout.c,v $
 * Revision 1.4  87/06/17  17:40:53  brandon
 * I'm beginning to think that it is impossible to get to the bottom of the
 * screen....
 * 
 * Revision 1.3  87/06/11  16:37:20  brandon
 * Still didn't move to BOS.  Now using term{cap, info} low-level code.
 * 
 * Revision 1.2  87/06/09  11:28:14  brandon
 * Forgot to move to BOS before starting the shell (suspending).  This is done
 * with mvcur(), since otherwise temporary windows (^V) would fail.
 * 
 * Revision 1.1  87/06/01  16:32:06  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#include <signal.h>

/*
 * Internal routine used by inl() and inc() to suspend the program.  Under
 * System V, this does a subshell instead.
 */

static void _putc(ch)
char ch; {
	(void) write(1, &ch, 1);
}

#ifndef TERMCAP
#include <term.h>
#define CM		cursor_address
#endif

static void bos() {
/* this does a move without changing curses... multiple windows would fail. */
	(void) tputs(tgoto(CM, 1, LINES - 1), 0, _putc);
}

#ifdef SIGTSTP

void _inlsusp() {
	(void) nocbreak();
	(void) nonl();
	(void) echo();	/* this is a macro in the BSD curses, hurrah! */
	bos();
	(void) kill(getpid(), SIGSTOP);
	(void) cbreak();
	(void) nl();
	(void) noecho();
	(void) move(y, x);
	(void) clearok(curscr);
	(void) wrefresh(curscr);
}

#else

void _inlsusp() {
	char *sh;
	int (*oint)(), (*oquit)();
	int pid, status;

	if ((sh = getenv("SHELL")) == (char *) 0)
		sh = "/bin/sh";
	oint = signal(SIGINT, SIG_IGN);
	oquit = signal(SIGQUIT, SIG_IGN);
	bos();
	(void) nocbreak();
	(void) nl();
	(void) system("stty echo");	/* ECCH!  echo() conflicts with Unify!!! */
	/* presumably, I don't need vfork() because of the above */
	switch (pid = fork()) {
	case -1:
		status = -1;
		break;
	case 0:
		(void) signal(SIGINT, SIG_DFL);
		(void) signal(SIGQUIT, SIG_DFL);
		(void) execlp(sh, sh, "-i", (char *) 0);
		_exit(-1);
	default:
		while (wait(&status) != pid)
			;
		break;
	}
	(void) noecho();
	(void) nonl();
	(void) cbreak();
	(void) signal(SIGINT, oint);
	(void) signal(SIGQUIT, oquit);
	(void) clearok(curscr);
	(void) wrefresh(curscr);
	if (status == -1)
		prtmsg(1, 23, "Shell returned -1");
}

#endif
