/*
 * $Header: ringmenu.c,v 1.9 87/06/11 15:50:36 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	ringmenu.c,v $
 * Revision 1.9  87/06/11  15:50:36  brandon
 * Fixed page backup bug, used XRC_NOFLSH in showmenu(), misc. other fixes.
 * 
 * Revision 1.8  87/06/02  18:47:53  brandon
 * Had forgotten to force input to uppercase.
 * 
 * Revision 1.7  87/06/02  18:41:05  brandon
 * Now uses XRC_FWDGO, so pressing RETURN has a more intuitive result.
 * 
 * Revision 1.6  87/06/02  18:23:10  brandon
 * Fixed another page-number bug.
 * 
 * Revision 1.5  87/06/02  17:35:22  brandon
 * Fixed bug with `page' numbering, and added a setraw() in case it's called
 * before any other USC functions.
 * 
 * Revision 1.4  87/06/02  16:14:38  brandon
 * Fully linted.
 * 
 * Revision 1.3  87/06/02  16:02:33  brandon
 * Partially linted.
 * 
 * Revision 1.2  87/06/02  15:47:15  brandon
 * Partially linted.
 * 
 * Revision 1.1  87/06/02  15:37:27  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Ring menu manager.  You haven't seen a real ring menu yet; this one uses
 * the full capability of the key primitives (including using "view" to show
 * all the entries on the menu, one per line in a temp window), it scrolls if
 * the menu is wider than the screen, etc.  Rather than using `!' shellout,
 * the ^P convention is used (subshell for Sys5, suspend for BSD) as a part
 * of the input function (the same one used by inl()).  (Late-breaking news:
 * the latest version of I4GL now supports wrapound ring menus.  But the help
 * feature is still unique to USC.)
 *
 * space, CR	next (wraps)
 * tab		exit without selecting
 * esc		execute
 * ^F		next `page'
 * ^B		last `page'
 * ^X		exit program
 * ^P		shellout/suspend
 * ^H		previous (wraps)
 * ^V		display all menu entries in a window
 */

static int paws(w)
WINDOW *w; {
	(void) wmove(w, LINES - 1, 0);
	(void) wattron(w, A_STANDOUT);
	(void) waddstr(w, " Press ENTER for the next page, or TAB to return: ");
	(void) wattroff(w, A_STANDOUT);
	(void) wclrtoeol(w);
	(void) wrefresh(w);
	switch (incs(XRC_NOFLSH)) {
	case -2:
		return 0;
	case -3:
		return 1;
	}
	/*NOTREACHED*/
}

static void showmenu(title, items)
char *title;
struct cmd *items; {
	int nitem, line;
	WINDOW *w;

	(void) refresh();	/* otherwise incs() zaps the top two lines */
	if ((w = newwin(LINES, COLS, 0, 0)) == (WINDOW *) 0)
		xerror("showmenu", -1, "no space for menu window for `%s'", (title == (char *) 0? "(null)": title));
	(void) mvwaddstr(w, 0, 0, "Commands on th");
	if (title == (char *) 0 || title[0] == '\0')
		(void) waddstr(w, "is");
	else
		(void) wprintw(w, "e %s", title);
	(void) waddstr(w, " menu:\n");
	(void) waddstr(w, "SPACE or ENTER moves forward, BACKSPACE moves backward, ESC selects, TAB exits;\n");
	(void) waddstr(w, "      CONTROL-F moves forward one page, CONTROL-B moves backward one page.\n");
	line = 4;
	for (nitem = 0; items[nitem].c_key != EOM; nitem++) {
		if (line == LINES - 1)
			if (!paws(w))
				break;
			else {
				(void) wmove(w, 4, 0);
				(void) wclrtobot(w);
				line = 4;
			}
		(void) wmove(w, line, 0);
		if (items[nitem].c_title != INVISIBLE)
			(void) waddstr(w, items[nitem].c_title);
		else
			(void) waddch(w, items[nitem].c_key);
		(void) wprintw(w, "\t%s", items[nitem].c_desc);
		line++;
	}
	(void) paws(w);
	(void) delwin(w);
	(void) touchwin(stdscr);
}

int ringmenu(title, menu/* , initial */)
char *title;
struct cmd *menu; {
	int *mpage;
	int nitem, npage, len, page, item, ch, x, y;

	setraw();
	npage = 1;
	if (title != (char *) 0 && *title != '\0')
		len = strlen(title) + 2;
	else
		len = 0;
	for (nitem = 0; menu[nitem].c_key != EOM; nitem++)
		if (menu[nitem].c_title != INVISIBLE)
			if ((len += strlen(menu[nitem].c_title) + 2) >= COLS - 1) {
				npage++;
				if (title != (char *) 0 && *title != '\0')
					len = strlen(title) + 2;
				else
					len = 0;
			}
	if ((mpage = (int *) malloc((unsigned) (npage + 1) * sizeof *mpage)) == (int *) 0)
		xerror("ringmenu", 0, "No memory for menu `%s' page layout", (title == (char *) 0? "(null)": title));
	npage = 0;
	if (title != (char *) 0 && *title != '\0')
		len = strlen(title) + 2;
	else
		len = 0;
	mpage[0] = 0;
	for (nitem = 0; menu[nitem].c_key != EOM; nitem++)
		if (menu[nitem].c_title != INVISIBLE)
			if ((len += strlen(menu[nitem].c_title) + 2) >= COLS - 1) {
				mpage[++npage] = nitem;
				if (title != (char *) 0 && *title != '\0')
					len = strlen(title) + 2;
				else
					len = 0;
			}
	mpage[++npage] = -1;
	item = 0;
	page = 0;
	for (;;) {
		(void) move(0, 0);
		if (title != (char *) 0 && title[0] != '\0')
			(void) printw("%s: ", title);
		for (len = mpage[page]; menu[len].c_key != EOM && (page == npage - 1 || len < mpage[page + 1]); len++) {
			if (menu[len].c_title == INVISIBLE)
				continue;
			if (len == item)
				(void) attron(A_STANDOUT);
			(void) printw(" %s ", menu[len].c_title);
			if (len == item) {
				(void) attroff(A_STANDOUT);
				if (menu[len].c_desc != (char *) 0) {
					getyx(stdscr, y, x);
					(void) mvaddstr(1, 0, menu[len].c_desc);
					(void) clrtoeol();
					(void) move(y, x);
				}
			}
		}
		(void) clrtoeol();
		if (title != (char *) 0 && *title != '\0')
			(void) move(0, strlen(title) + 1);
		else
			(void) move(0, COLS - 1);
		(void) refresh();
		ch = incs(XRC_CFB|XRC_LOOK|XRC_GO|XRC_CHAR|XRC_BKSP|XRC_FWDGO);
		if (islower(ch))
			ch = toupper(ch);
		(void) move(0, 0);
		(void) clrtoeol();
		(void) move(1, 0);
		(void) clrtoeol();
		switch (ch) {
		case BKSP:
			if (--item < mpage[page])
				if (page-- == 0) {
					page = npage - 1;
					for (item = mpage[page]; menu[item].c_key != EOM; item++)
						;
					item--;
				}
			break;
		case BACK:
			free((char *) mpage);
			return BACK;
		case FWD:
			if (menu[++item].c_key == EOM) {
				page = 0;
				item = 0;
			}
			else if (mpage[page + 1] != -1 && item == mpage[page + 1])
				page++;
			break;
		case LOOK:
			showmenu(title, menu);
			break;
		case GO:
			free((char *) mpage);
			return menu[item].c_key;
		case CFWD:
			if (mpage[++page] == -1)
				page = 0;
			item = mpage[page];
			break;
		case CBACK:
			if (page-- == 0)
				page = npage - 1;
			item = mpage[page];
			break;
		default:
			for (len = 0; menu[len].c_key != EOM; len++)
				if ((islower(menu[len].c_key)? toupper(menu[len].c_key): menu[len].c_key) == ch) {
					free((char *) mpage);
					return menu[len].c_key;
				}
			(void) beep();
		}
	}
}
