/*
 * $Header: pdate.c,v 1.1 87/04/29 12:18:30 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	pdate.c,v $
 * Revision 1.1  87/04/29  12:18:30  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Display a value of type DATE.  Under UNIFY 3.2, this is easier...
 */

#ifdef UNIFY32

void pdate(buf)
short *buf; {
	char dbuf[8];

	(void) setraw();
	(void) attron(A_UNDERLINE);
	(void) dspdt(*buf, dbuf);	/* handles DATETP automatically */
	(void) printw("%.8s", dbuf);
	(void) attroff(A_UNDERLINE);
}

#else

void pdate(buf)
short *buf; {
	int date[3];

	(void) setraw();
	(void) attron(A_UNDERLINE);
	if (*buf == NULLDATE)
		(void) addstr("**/**/**");
	else {
		kdate(*buf, date);
		(void) printw("%02d/%02d/%02d", date[MONTH], date[DAY], date[YEAR]);
	}
	(void) attroff(A_UNDERLINE);
}
