/*
 * $Header: outscrf.c,v 1.4 87/05/22 18:01:22 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	outscrf.c,v $
 * Revision 1.4  87/05/22  18:01:22  brandon
 * another dumb bug (`(vid)'?)
 * 
 * Revision 1.3  87/05/22  17:58:48  brandon
 * Forgot to move() to the right place before doing output! :-(
 * 
 * Revision 1.2  87/04/29  14:43:24  brandon
 * Added cast to (double *) for pflt() call
 * 
 * Revision 1.1  87/04/29  13:18:44  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  outscrf() -- Display a value on the screen
 *
 * DIFFERENCE FROM UNIFY:  Screen fields with type FLT are handled specially.
 * See pflt.c for the reason; quick summary is that Unify Corp. blew it.
 */

void outscrf(x, y, type, len, buf)
char *buf; {
	(void) setraw();
	(void) move(y, x);
	switch (type) {
	case INT:
		pshort(len, (short *) buf);
		break;
	case LONG:
		plong(len, (long *) buf);
		break;
	case AMT:
		pamt(len, (long *) buf);
		break;
	case HAMT:
		phamt(len, (double *) buf);
		break;
	case STRNG:
		pstr(len, buf);
		break;
	case DATE:
		pdate((short *) buf);
		break;
	case HR:
		ptime((short *) buf);
		break;
	case FLT:
		pflt(len, (double *) buf, -1);	/* use %g, we don't know the #dec */
		break;
	default:
		xerror(-1, "outscrf", "Unknown type %d", type);
	}
}
