/*
 * $Header: inc.c,v 1.1 87/06/02 11:01:55 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	inc.c,v $
 * Revision 1.1  87/06/02  11:01:55  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Input primitive.  Get a single input character.  If _sh_up is nonzero, shift
 * to uppercase.  Underline is used (when available) in place of foreground/
 * background stuff that curses doesn't grok anyway.
 *
 * The `clrf' flag specifies whether the buffer is cleared or not prior to
 * input.  This is of doubtful utility, but....
 */

int inc(buf, clrf)
char *buf;
int clrf; {
	setraw();
	(void) attron(A_UNDERLINE);
	if (clrf)
		*buf = ' ';
	for (;;) {
		(void) printw("%c\b", *buf);
		(void) refresh();
		*buf = getchar() & 0x7f;
		switch (*buf) {
		case '\033':
		case '\005':
			(void) attroff(A_UNDERLINE);
			return GO;
		case '\t':
		case '\025':
			(void) attroff(A_UNDERLINE);
			return BACK;
		case '\n':
		case '\r':
		case ' ':
			(void) attroff(A_UNDERLINE);
			return (!clrf || *buf == ' '? FWD: FWD_OK);
		case '\b':
			(void) attroff(A_UNDERLINE);
			return BKSP;
		case '\006':
			(void) attroff(A_UNDERLINE);
			return CFWD;
		case '\002':
			(void) attroff(A_UNDERLINE);
			return CBACK;
		case '\026':
			(void) attroff(A_UNDERLINE);
			return LOOK;
		case '\030':
			(void) move(LINES - 1, 0);
			(void) clrtoeol();
			(void) refresh();
			(void) endwin();
			exit(0);
		case '\020':
			_inlsusp();
			break;
		case '\f':
		case '\022':
			(void) clearok(curscr);
			(void) wrefresh(curscr);
			break;
		default:
			if (*buf < ' ' || *buf == '\177') {
				(void) beep();
				break;
			}
			if (_sh_up && islower(*buf))
				*buf = toupper(*buf);
			return FWD_OK;
		}
	}
}
