/*
 * $Header: iflt.c,v 1.6 87/06/09 11:45:29 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	iflt.c,v $
 * Revision 1.6  87/06/09  11:45:29  brandon
 * Added code to relocate cursor after conversion error message.
 * 
 * Revision 1.5  87/06/01  08:30:02  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.4  87/05/26  13:31:47  brandon
 * Changed for new inl() (forces no-update mode).
 * 
 * Revision 1.3  87/05/12  12:04:13  brandon
 * Changed to pass FWD, BACK, GO without checking the data buffer
 * 
 * Revision 1.2  87/04/29  11:30:35  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Input a float.  This time, they're dumb; take what we're given, no matter
 * how any decimals -- UNITRIEVE can figure it out for itself, since it won't
 * let me!  (This is UNIFY's own behavior, in fact.)
 */

int iflt(len, buf)
register double *buf; {
	char ibuf[17];
	int rc, cnt, sign, y, x;
	double dec;

	setraw();
	if (len > 17)
		len = 17;
	getyx(stdscr, y, x);
	for (;;) {
		(void) move(y, x);
		if ((rc = inl(ibuf, len, 1)) == BACK || rc == FWD || rc == GO || rc == LOOK)
			return rc;
		for (cnt = 0; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len) {
			prtmsg(1, 23, "Invalid float");
			continue;
		}
		*buf = 0.0;
		sign = 0;
		dec = 0;
		if (ibuf[cnt] == '-') {
			sign = 1;
			if (++cnt == len) {
				prtmsg(1, 23, "Invalid float");
				continue;
			}
		}
		for (; cnt < len && isdigit(ibuf[cnt]); cnt++) {
			*buf *= 10.0;
			*buf += ibuf[cnt] - '0';
		}
		if (ibuf[cnt] == '.') {
			dec = 10.0;
			for (cnt++; cnt < len && isdigit(ibuf[cnt]); cnt++) {
				*buf += (ibuf[cnt] - '0') / dec;
				dec *= 10.0;
			}
		}
		for (; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len)
 			break;
		prtmsg(1, 23, "Invalid float");
	}
	if (sign)
		*buf = - *buf;
	return rc;
}
