/*
 * $Header: dbfile.c,v 1.3 87/05/12 10:58:24 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	dbfile.c,v $
 * Revision 1.3  87/05/12  10:58:24  brandon
 * OOPS:  null filename if no extension!
 * 
 * Revision 1.2  87/04/29  11:30:17  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#include <sys/types.h>
#include <sys/stat.h>

/*
 * Generate a file name.  Append the given extension (if any), and try to
 * find it in the DBPATH or the current directory.
 */

char *dbfile(fn, ext)
char *fn, *ext; {
	char fnb[1024];
	static char path[1024];
	static char *dbpath = (char *) 0;
	struct stat exist;

	if (ext != (char *) 0)
		(void) sprintf(fnb, "%s.%s", fn, ext);
	else
		(void) strcpy(fnb, fn);
	if (dbpath == (char *) 0 && (dbpath = getenv("DBPATH")) == (char *) 0)
		dbpath = ".";
	(void) sprintf(path, "%s/%s", dbpath, fnb);
	if (stat(path, &exist) == 0)
		return path;
	(void) strcpy(path, fnb);
	return (stat(path, &exist) == 0? path: (char *) 0);
}
